/**
 * Copyright ta6b ( http://wonderfl.net/user/ta6b )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mW4y
 */

//Flashで作る3Dのお勉強4
//バードビュー。z軸のラッピングの実装。
//↑↓：前進・後進　SPACE：視点を上に　→←：視点を左右に
package 
{
	import flash.display.Sprite;
	import flash.events.*;
	import flash.text.TextField;
	import flash.ui.Keyboard;
	[SWF(backgroundColor=0x333333, frameRate=60)]                                
	public class Test3D extends Sprite
	{
		private var plates:Array;
		private var numPlates:int = 100;
      		private var focalLength:Number = 250;
		private var vpX:Number = stage.stageWidth / 2;
		private var vpY:Number = stage.stageHeight / 2;
		private var floor:Number = 250;
		private var ax:Number = 0;
		private var ay:Number = 0;
		private var az:Number = -.5;
		private var vx:Number = 0;
		private var vy:Number = 0;
		private var vz:Number = 0;
		private var gravity:Number = .3;
		private var friction:Number = .98;
		function Test3D() 
		{
			init();
		}
		
		private function init():void
		{
			plates = new Array();
			for (var i:int = 0; i < numPlates; i++){
			var plate = new Plate(Math.random() * 300, Math.random() * 0xffffff);
			plates.push(plate);
			plate.xpos = Math.random() * 5000 - 2500;
			plate.ypos = floor;
			plate.zpos = Math.random() * 10000;
			addChild(plate);
			}
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownHandler);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUpHandler);
		}
		
		private function enterFrameHandler(e:Event):void
		{
			vx += ax;
			vy += ay;
			vz += az;
			vy -= gravity;
			for (var i:int = 0; i < numPlates; i++) {
				var plate:Plate = plates[i];
				move(plate);
			}
			vx *= friction;
			vy *= friction;
			vz *= friction;
			sortZ();
		}
		
		private function move(plate:Plate):void {
			plate.xpos += vx;
			plate.ypos += vy;
			plate.zpos += vz;
						
			if (plate.ypos < floor) {
				plate.ypos = floor;
			}
			if (plate.zpos < -focalLength) {
				plate.zpos += 10000;
			}
			if (plate.zpos > 10000-focalLength) {
				plate.zpos -= 10000;
			}
						
			
			var scale:Number = focalLength / (focalLength + plate.zpos);
			plate.scaleX = plate.scaleY = scale;
			plate.x = vpX + plate.xpos * scale;
			plate.y = vpY + plate.ypos * scale;
			plate.alpha = scale*.7+.3;
			
		}
		
		private function sortZ():void {
			plates.sortOn("zpos", Array.DESCENDING | Array.NUMERIC);
			for (var i:int = 0; i < numPlates; i++) {
				var plate:Plate = plates[i];
				setChildIndex(plate, i);
			}
		}
		
		private function onKeyDownHandler(e:KeyboardEvent):void {
			switch(e.keyCode) {
				case Keyboard.UP:
				az = -1;
				break;
				case Keyboard.DOWN:
				az = 1;
				break;
				case Keyboard.LEFT:
				ax = 1;
				break;
				case Keyboard.RIGHT:
				ax = -1;
				break;
				case Keyboard.SPACE:
				ay = 1;
				break;
				
				default:
				break;
			}
		}
		
		private function onKeyUpHandler(e:KeyboardEvent):void {
			switch(e.keyCode) {
				case Keyboard.UP:
				case Keyboard.DOWN:
				az = -.5;
				break;
				
				case Keyboard.LEFT:
				case Keyboard.RIGHT:
				ax = 0;
				break;
				
				case Keyboard.SPACE:
				ay = 0;
				break;
				
				default:
				break;
			}
		}
	}
	
}
import flash.display.Sprite;
	
	internal class Plate extends Sprite 
	{
		private var w:Number;
		public var xpos:Number = 0;
		public var ypos:Number = 0;
		public var zpos:Number = 0;
		public var vx:Number = 0;
		public var vy:Number = 0;
		public var vz:Number = 0;
		function Plate(w:Number = 100, color:uint = 0xffffff)
		{
			this.w = w;
			graphics.lineStyle(1, 0xffffff);
			graphics.beginFill(color);
			graphics.drawRect( -w / 2, -w / 2, w, w);
			graphics.endFill();
		}
	}