/**
 * Copyright zmaxlin ( http://wonderfl.net/user/zmaxlin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mVsW
 */

// forked from clockmaker's 朝ワンの方へ
package {
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.*;
	
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.shaders.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=465, height=465, frameRate=60)]

	public class AsaWon extends BasicView {
		
		static private const IMAGE_URL:String = 
			"http://clockmaker.jp/labs/090701_wonda/wonderfl.jpg";
		
		private var rot:Number = 0 // 角度
		private var cylinder:Cylinder;
		private var loader:Loader = new Loader();
		private var light:PointLight3D = new PointLight3D();
		
		public function AsaWon() {
			stage.quality = "medium"
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
			loader.load(new URLRequest(IMAGE_URL), new LoaderContext(true));
		}
		
		public function init(e:Event):void {
			
            // 球面のポリゴンに貼り付けるテクスチャ(フラットポリゴンを使用)を作成します
            var fileMat:BitmapMaterial = new BitmapMaterial(Bitmap(loader.content).bitmapData)
            var shader:GouraudShader = new GouraudShader(light, 0xFFFFFF, 0x0);
            var shadedMat:ShadedMaterial = new ShadedMaterial(fileMat, shader);
            
			cylinder = new Cylinder(shadedMat, 250, 800, 20, 5);
			scene.addChild(cylinder);
			
			startRendering();
		}
		
		
		override protected function onRenderTick(event:Event=null):void {
			// マウスの位置に応じて角度を設定
			var targetRot:Number = ( mouseX / stage.stageWidth ) * 720
			rot += (targetRot - rot) * 0.02;
			
			// 角度に応じてカメラの位置を設定
			camera.x = 1000 * Math.sin(rot * Math.PI / 180);
			camera.z = 1000 * Math.cos(rot * Math.PI / 180);
			camera.y += (800 * mouseY / stage.stageHeight - 400 - camera.y) * 0.1;
			
			// 地球は常に回転させておく
			cylinder.yaw(1)
			
			// 常にカメラの位置にライトを設置する
			light.copyPosition(camera);
			
			super.onRenderTick(event);
		}
		
	}
}
