/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mVdb
 */

package{
    import net.hires.debug.Stats;
    import flash.display.MovieClip;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.BlurFilter;
    import flash.system.Security;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;
    import com.actionsnippet.qbox.*;
    import Box2D.Common.Math.*;

    public class Sample extends MovieClip {
        private const DEPTH:Number = 1;
        private const camera_length:Number = 20;

        private var sim:QuickBox2D;
        private var view:BasicView;

        private var mapping:Array = [];
            
        private var sx:Number;
        private var sy:Number;
            
        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        private const path:String = "http://assets.wonderfl.net/images/related_images";
        private const filename:String = path+"/3/35/3590/359061d357d721a573fae94cc4d8b2819a72122c";
        private const filename1:String = path + "/e/ed/ed1c/ed1cadf0fdd830922653b0fa2a5667315bb85ef5";
        private const filename2:String = path + "/2/29/2944/2944a982d2a8d7928f0e8add944f8d28158090e3";
        //private const filename3:String = path + "/b/b0/b0bd/b0bd1ed4e975f909d61a84742f77faab50201f7b";
        private const filename3:String = path + "/3/39/3933/393330f30c725032b7ddee52247d9d46c7041bfa"

        private const sideMaterial:MaterialObject3D = new ColorMaterial();//new BitmapFileMaterial(filename3);
        
        public function Sample() {
            addChild(new Stats());

            //new MovieClip();
            sim = new QuickBox2D(new MovieClip());
            sim.start();

            view = new BasicView();
            addChild(view);

            sx = stage.width;
            sy = stage.height;

            var material2:CompositeMaterial = new CompositeMaterial();
            //material.addMaterial(new ColorMaterial(0x808080));
            material2.addMaterial(new BitmapFileMaterial(filename1));
            material2.addMaterial(new WireframeMaterial(0x000000));

            var material:CompositeMaterial = new CompositeMaterial();
            //material.addMaterial(new ColorMaterial(0x808080));
            material.addMaterial(new ColorMaterial());
            material.addMaterial(new WireframeMaterial(0x000000));

            addBox({x: 0, y: 5, width:50, height:2, density:0, angle:-5/180*Math.PI}, new BitmapFileMaterial(filename1));
            
            var head:QuickObject = addBox({x:5*2-10, y:(-10+5)*2, width:1*2, height:1*2}, material);
            //var torsoA:QuickObject = addBox({x:5*2-10, y:(-10+6)*2, width:1.5*2, height:0.8*2}, material)
            var torsoB:QuickObject = addBox({x:5*2-10, y:(-10+6.5)*2, width:1.5*2, height:0.8*2*2}, material)
            //var torsoC:QuickObject = addBox({x:5*2-10, y:(-10+7)*2, width:1.0*2, height:0.8*2}, material)
            var pelvis:QuickObject = addBox({x:5*2-10, y:(-10+7.5)*2, width:1.0*2, height:0.8*2}, material)
            var leftLegA:QuickObject = addBox({x:4.75*2-10, y:(-10+8.5)*2, width:0.4*2, height:1.75*2}, material);
            var leftLegB:QuickObject = addBox({x:4.75*2-10, y:(-10+9.75)*2, width:0.4*2, height:1.5*2}, material);
            var rightLegA:QuickObject = addBox({x:5.29*2-10, y:(-10+8.5)*2, width:0.4*2, height:1.75*2}, material);
            var rightLegB:QuickObject = addBox({x:5.29*2-10, y:(-10+9.75)*2, width:0.4*2, height:1.5*2}, material);
            var leftArmA:QuickObject = addBox({x:3.6*2-10, y:(-10+5.8)*2, width:1.3*2, height:0.35*2}, material);
            var leftArmB:QuickObject = addBox({x:2.5*2-10, y:(-10+5.8)*2, width:1.25*2, height:0.35*2}, material);
            var rightArmA:QuickObject = addBox({x:6.4*2-10, y:(-10+5.8)*2, width:1.3*2, height:0.35*2}, material);
            var rightArmB:QuickObject = addBox({x:7.5*2-10, y:(-10+5.8)*2, width:1.25*2, height:0.35*2}, material);

            torsoB.body.SetLinearVelocity(new b2Vec2(-1, -50));
             
            var anchor:b2Vec2 = new b2Vec2();
            function connect(a:QuickObject, b:QuickObject, lower:Number, upper:Number, offX:Number=0, offY:Number = 0):QuickObject{
                 var min:Number = Math.min(a.y, b.y);
                 var max:Number = Math.max(a.y, b.y);
                 anchor.y = min + (max - min) * 0.5 + offY;
                 min = Math.min(a.x, b.x);
                 max = Math.max(a.x, b.x);
                 anchor.x = min + (max - min) * 0.5 + offX;
                return sim.addJoint({a:a.body, b:b.body, x1:anchor.x, y1:anchor.y, lowerAngle:lower, upperAngle:upper});
            }
             
            sim.setDefault({type:"revolute", collideConnected:false, enableLimit:true, lineColor:0xFFFFFF});
             
            connect(head, torsoB, -.2, .2);
            //connect(torsoA, torsoB,-.2, .2);
            //connect(torsoC, torsoB,-.2, .2);
            connect(torsoB, pelvis,-.2, .2);
             
            connect(pelvis, leftLegA, -1, 1, 0*2, -0.5*2);
            connect(leftLegA, leftLegB, -1, 1);
             
            connect(pelvis, rightLegA, -1, 1, 0*2, -0.5*2);
            connect(rightLegA, rightLegB, -1, 1);
             
            connect(torsoB, leftArmA, -2, 1);
            connect(leftArmA, leftArmB, -2, 1);
             
            connect(torsoB, rightArmA, -1, 2)
            connect(rightArmA, rightArmB, -1, 2)
 
            addEventListener(Event.ENTER_FRAME, update);
        }

        public function update(e:Event):void{
            for each(var v:Array in mapping) {
                v[1].x = -v[0].x;
                v[1].y = -v[0].y;
                v[1].rotationZ = v[0].angle * 180 / Math.PI;
            }

            var c:Number = (mouseX / sx - 0.5) * (Math.PI);
            var d:Number = (mouseY / sy) * (Math.PI /2);
            view.camera.x = Math.sin(c) * Math.cos(d) * camera_length;
            view.camera.z = Math.cos(c) * Math.cos(d) * camera_length;
            view.camera.y = Math.sin(d) * camera_length;

            view.singleRender();
        }


        private function create(obj:QuickObject, obj3d:TriangleMesh3D):QuickObject {
            obj3d.rotationX = 90;
            view.scene.addChild(obj3d);
            mapping.push([obj, obj3d]);
            return obj;
        }

        private function addBox(param:Object, material:MaterialObject3D):QuickObject {
            var obj:QuickObject = sim.addBox(param);
            var mlist:MaterialsList = new MaterialsList({all:sideMaterial, top:material, bottom:material});
            var obj3d:TriangleMesh3D = new Cube(mlist, obj.params.width, obj.params.height, DEPTH);
            return create(obj, obj3d);
        }
    }
}
