/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mV4h
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import caurina.transitions.Tweener;
    
    public class FlashTest extends Sprite {
    		private var _balls:Array;			// ball格納配列
    		private var _unit:Number = 15;		// グラフ間隔
      	private var _defaultY:Number = 400;	// 基準Y座標
      	
    		// グラフデータ
    		private var _data:Array = [ 5, 40, 55, 80, 82, 90, 98, 101, 120, 140, 145, 156, 160, 166, 170, 172, 173, 176, 190, 210, 205, 212, 220, 223, 240, 244, 258, 269, 270, 277 ];		
    		
        public function FlashTest() {
            // write as3 code here..
            init();
        }
        
        private function init():void {
        		// 背景
     		var background:Background = new Background(_defaultY, _unit);
        		addChild(background);
        		
        		_balls = new Array();
        		for( var i:uint = 0; i < _data.length; i++ ) {
        			var ball:Ball = new Ball( _unit * (i + 1), _defaultY );
        			_balls.push(ball);
        			addChild(ball);
           		Tweener.addTween( ball, { y:_defaultY - _data[i], time:0.5, delay:0.08 * i, transition:"easeoutCirc" } )
        		}
        		
        		addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
        		graphics.clear();
        		graphics.lineStyle(1, 0x000000);
        		graphics.moveTo(_balls[0].x, _balls[0].y);
        		
			for( var i:uint = 0; i < _balls.length; i++ ){
				graphics.lineTo(_balls[i].x, _balls[i].y);
			}
			
			// 最後の ball が指定位置に到達したらイベントリスナーを削除
			if(_balls[_balls.length - 1].y == _data[_data.length - 1]){
				removeEventListener(Event.ENTER_FRAME, loop);
			}
        }
    }
}

import flash.display.Sprite;
internal class Ball extends Sprite {
	public function Ball(posX:Number, posY:Number) {
		x = posX;
		y = posY;
		
		graphics.beginFill(0x000000);
		graphics.drawCircle(0,0,2);
		graphics.endFill();
	}
}

import flash.display.Sprite;
internal class Background extends Sprite {
	public function Background(posY:Number, unit:Number) {
		var numX:Number = Math.floor(465 / unit);
		for( var i:uint = 0; i < numX; i++ ){
			graphics.lineStyle(1, 0x0000FF, 0.1);
			graphics.moveTo(unit * i, posY);
			graphics.lineTo(unit * i, 0);
			graphics.endFill();
		}
		
		var numY:Number = Math.floor(400 / unit);
		for( var j:uint = 0; j < numY; j++ ){
			graphics.lineStyle(1, 0x0000FF, 0.1);
			graphics.moveTo(0, posY - unit * j);
			graphics.lineTo(465, posY - unit * j);
			graphics.endFill();
		}
	}
}