/**
 * Copyright su8erlemon ( http://wonderfl.net/user/su8erlemon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mUxE
 */

package  {
    import flash.display.Shape;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.display.StageQuality;
    import flash.events.MouseEvent;
    import frocessing.color.ColorHSV;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;
    import frocessing.color.ColorHSL;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.media.SoundMixer;
    import flash.media.SoundChannel;
    import flash.system.Security;
    import flash.filters.ColorMatrixFilter;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import frocessing.color.ColorRGB;
    import frocessing.color.ColorCMY;
    
    public class Main extends MovieClip{

        private var SW:int = 465;
        private var SH:int = 465;
        
        private const MAX_NUM:int = 1;
        
        private var st:Sprite = new Sprite();
            
        private var startTime:Number;
        private var prevBeat:Number;
        
        private var sound:Sound = new Sound();
        
        private var spectBytes:ByteArray = new ByteArray();
        private var spectrum:Vector.<Number> = new Vector.<Number>(512, true);
        private var spectrumAverage:Number = 0.0;

        private var line:Shape = new Shape();
        
        private var col:uint=0xffffff;
        private var rl:Number=0;
        
        public function Main() {
            Security.loadPolicyFile('http://su8erlemon.com/crossdomain.xml');
            sound.addEventListener(Event.COMPLETE, soundLoadCompleteHandler);
            sound.load(new URLRequest('http://su8erlemon.com/lab/music/04_Kling_Klang.mp3'));            
        }
        
        private function soundLoadCompleteHandler(e:Event):void{
            sound.removeEventListener(Event.COMPLETE, soundLoadCompleteHandler);
            init();
        }
        
        private function init():void{
            if(stage.stageWidth != 0){
                SW = stage.stageWidth;
                SH = stage.stageHeight;
            }
            stage.frameRate = 60;
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var back:Shape = new Shape();
            back.graphics.beginFill(0x000000);
            back.graphics.drawRect(0,0,SW,SH);
            back.graphics.endFill();
            addChild(back);
                // addChild(new Stats())
            
            st.x = SW/2;
            st.y = SH/2;            
            addChild(st);
                        
            startTime = getTimer();
            prevBeat = 0.0;
            
            addEventListener(Event.ENTER_FRAME,loop);
            
            var sc:SoundChannel = sound.play();
            sc.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
        }
        
        private function soundCompleteHandler(e:Event):void{
            var sc:SoundChannel = e.target as SoundChannel;
            
            sc.removeEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            sc.stop();
            sc = sound.play();
            sc.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            
            prevBeat = 0.0;
            startTime = getTimer();
        }
        
    
        private function loop(e:Event):void{            
            computeSpectrum();
            
            rl += 0.001;
            
            var interval:uint = ( 60 * 1000)/130;
            var current:Number = getTimer() - startTime;
            var beat:uint = int(current/interval*2);
           
            if(int(beat * 0.5) != int(prevBeat * 0.5)){
                
                var v0:int = 20+spectrumAverage * 70;
                
                for(var i:int = 0;i<30;i++)     
                {
                    if(v0 > 70)v0=70;
                    var rect:Node = new Node(v0*i*0.05,col);
                    st.addChild(rect);
                }
            }
            
            prevBeat = beat;
        }
        
        
        private function computeSpectrum():void{
            var bytes:ByteArray = spectBytes;
            bytes.position = 0;
            
            SoundMixer.computeSpectrum(bytes, false,65);
            
            var total:Number = 0;
            var plus:Number = 0;
            var pc:uint = 0;
            var minus:Number = 0;
            var mc:uint = 0;
            var numbers:Vector.<Number> = spectrum;
            for (var i:uint = 0; i < 512; ++i) {
                var n:Number = bytes.readFloat() * 2.0;
                total += Math.abs(n);
                if (n > 0) {
                    plus += n;
                    ++pc;
                }
                else if (n < 0) {
                    minus += n;
                    ++mc;
                }
                numbers[i] = n;
            }
            spectrumAverage = total / 512.0;
            
        }
    }
    
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.display.DisplayObject;
import flash.events.Event;
import flash.display.Shape;
import flash.display.Graphics;

class Node extends Sprite
{
       private var shape1:Shape = new Shape();
       private var shape1gr:Graphics;

       private var t:Number=0;
       private var v:Number = 40;
       private var v0:Number = 40;
       private var col:uint=0;
       private const G:Number = 9.8;
       
       public function Node(_v0:Number,_col:uint)
       {
            v0 = _v0;
            shape1gr = shape1.graphics;
            addChild(shape1);
            
            col = _col;
            
            addEventListener(Event.ENTER_FRAME,update);
            shape1.rotation = Math.random()*90;
       }
        
       private function update(w:Event):void
       {   
              t += 0.2;
           
           v = 6 + v0 * t  - (0.5 * G *  t * t);
        
           if(v < 6){
            this.parent.removeChild(this);
            removeEventListener(Event.ENTER_FRAME,update);                
           }

           
           shape1gr.clear();
           shape1gr.beginFill(col,1);
           shape1gr.drawCircle(v,0,4);
           shape1gr.drawCircle(-v,0,4);
           shape1gr.drawCircle(0,v,4);
           shape1gr.drawCircle(0,-v,4);
           shape1gr.endFill();
           shape1.rotation += 1 ;
       } 
}