/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mU74
 */

// forked from psyark's flash on 2009-12-9
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
	/**
	 * このクラスでは、3D座標を投影して2D座標（スクリーン座標）を得ることで
	 * 簡単な3D表現を行います。
	 */
	public class Test10 extends Sprite {
		private var viewport:Shape;
		private var vertices:Vector.<Number>;
		private var uvtData:Vector.<Number>;
		private var worldMatrix:Matrix3D;
		private var viewMatrix:Matrix3D;
		private var projection:PerspectiveProjection;
		
		public function Test10() {
			// 描画対象となるShapeを作成し、表示リストに追加します。
			viewport = new Shape();
			viewport.x = stage.stageWidth  * 0.5;
			viewport.y = stage.stageHeight * 0.5;
			addChild(viewport);
			
			createMesh();
			
			worldMatrix = new Matrix3D();
			viewMatrix = new Matrix3D();
			viewMatrix.appendTranslation(0, 0, 150);
			projection = new PerspectiveProjection();
			projection.fieldOfView = 60;
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		/**
		 * 3D形状を作成します
		 */
		private function createMesh():void {
			vertices = new Vector.<Number>();
			uvtData = new Vector.<Number>();
			for (var i:int=0; i<9; i++) {
				vertices.push(Math.random() * 100 - 50);
				uvtData.push(0);
			}
		}
		
		/**
		 * フレームごとの処理
		 */
		private function enterFrameHandler(event:Event):void {
			update();
			render();
		}
		
		/**
		 * 更新
		 */
		private function update():void {
			worldMatrix.appendRotation(1, Vector3D.Y_AXIS);
		}
		
		/**
		 * 描画
		 */
		private function render():void {
			// World行列、View行列、Projection行列を結合して一つの行列にする
			var m:Matrix3D = new Matrix3D();
			m.append(worldMatrix);
			m.append(viewMatrix);
			m.append(projection.toMatrix3D());
			
			// 上記の行列を使って頂点座標を投影する
			var projected:Vector.<Number> = new Vector.<Number>();
			Utils3D.projectVectors(m, vertices, projected, uvtData);
			
			viewport.graphics.clear();
			viewport.graphics.lineStyle(-1, 0xFFFFFF);
			viewport.graphics.beginFill(0x000066);
			viewport.graphics.drawTriangles(projected);
			viewport.graphics.endFill();
		}
	}
}