/**
 * Copyright sct73 ( http://wonderfl.net/user/sct73 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mTW7
 */

// forked from bradsedito's 3D Perlin Particle's
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;    
    import com.greensock.*;
//  import perlin.Particle;
    
    [SWF(width='400',height='400',frameRate='90',backgroundColor='0x000000')]
    public class Main extends Sprite 
    {
        private const MAX_PARTICLES: int = 2000;
        private const colorTransform: ColorTransform = new ColorTransform( 0.92, 0.96, 0.94 );
        private const filter: BlurFilter = new BlurFilter( 4, 4, 6 );
        private const origin: Point = new Point();
        
        private var screen: BitmapData;
        private var forceCalc: BitmapData;
        private var forceField: BitmapData;
        private var forceMatrix: Matrix;
        private var octaves: Array;
        private var p0: Point;
        private var p1: Point;
        private var particles: Particle;
        private var phase0: Number;
        private var phase1: Number;
        private var freq0: Number;
        private var freq1: Number;

        public function Main()
        {
            init();
        }
        
        private function init(): void
        {
            stage.quality = StageQuality.MEDIUM
            ;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var scale: Number = 2;
            
            screen = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
            forceField = screen.clone();
            forceCalc = new BitmapData( screen.width / scale, screen.height / scale, false, 0 );
            forceMatrix = new Matrix();
            forceMatrix.scale( scale, scale );
        
            addChild( new Bitmap( screen ) );
            
            octaves = [
                p0 = new Point(),
                p1 = new Point()
            ];
            
            freq0 = 220 / 2000;
            freq1 = 110 / 2000;
            
            phase0 = 0.0;
            phase1 = 0.0;
            
            createParticles();
            
            stage.addEventListener( Event.ENTER_FRAME, enterFrame );
        }
        
        private function createParticles(): void
        {
            var p: Particle;
            
            var i: int = 0;
            var n: int = MAX_PARTICLES;
            
            p = particles = new Particle();
            
            for(;i<n;++i)
            {
                p = p.next = new Particle();
                initParticle(p);
            }
        }
        
        private function initParticle(p: Particle): void
        {
            p.x = stage.stageWidth * 0.5;
            p.y = stage.stageHeight * 0.5;
            
            p.vx = (Math.random() - Math.random()) * 4;
            p.vy = (Math.random() - Math.random()) * 4;
        }

        private function enterFrame( event: Event ): void
        {
            const width: int = screen.width;
            const height: int = screen.height;
            
            const speed: Number = 0.10;
            
            var ran: Function = Math.random;
            
            phase0 += freq0;
            if( phase0 > 1 ) --phase0;
            
            phase1 += freq1;
            if( phase1 > 1 ) --phase1;
            
            var a0: Number = phase0 * 2 * Math.PI;
            var a1: Number = phase1 * 2 * Math.PI;
            
            var sin0: Number = Math.sin( a0 );
            var cos0: Number = Math.cos( a0 );
            
            var sin1: Number = Math.sin( a1 );
            var cos1: Number = Math.cos( a1 );
            
            p0.x += speed;
            p0.y -= speed;
            p1.x -= speed;
            p1.y += speed;
            
            forceCalc.perlinNoise( 0x40, 0x40, 2, 0xaabbcc, false, true, BitmapDataChannel.GREEN | BitmapDataChannel.BLUE, false, octaves );
            forceField.draw( forceCalc, forceMatrix );

            colorTransform.redMultiplier = 0.42 + sin0 * sin0 * 0.5;
            colorTransform.greenMultiplier = 0.46 + cos0 * cos0 * 0.5;
            colorTransform.blueMultiplier = 0.99;
            
            screen.applyFilter( screen, screen.rect, origin, filter );
            screen.draw( screen, null, colorTransform );
            
            var c: int;
            var p: Particle = particles.next;
            var r: int;
            var g: int;
            var b: int;
            
            do
            {    
                c = forceField.getPixel( p.x, p.y );
                p.vx += (((c & 0xff) - 0x80)/0x80);
                p.vy += ((((c >> 0x08) & 0xff) - 0x80)/0x80);
                
                p.vx *= 0.94;
                p.vy *= 0.94;
                
                p.x += p.vx;
                p.y += p.vy;

                if( p.x > width )
                {
                    p.vx *= -(1.0 + ran() + ran() + ran() + ran());
                    p.vx -= ran() + ran();
                    p.x = width - 1;
                    
                }
                else
                if( p.x < 0 )
                {
                    p.vx *= -(1.0 + ran() + ran() + ran() + ran());
                    p.vx += ran() + ran();
                    p.x = 0;
                }
                
                if( p.y > height )
                {
                    p.vy *= -(1.0 + ran() + ran() + ran() + ran());
                    p.vy -= ran() + ran();
                    p.y = height - 1;
                }
                else
                if( p.y < 0 )
                {
                    p.vy *= -(1.0 + ran() + ran() + ran() + ran());
                    p.vy += ran() + ran();
                    p.y = 0;
                }
                        
                c = screen.getPixel( p.x, p.y );        
                
                if( 0xffffff != c )
                {
                    r = ( c >> 0x10 ) & 0xff;
                    g = ( c >> 0x08 ) & 0xff;
                    b = c & 0xff;
                    
                    r += 0x80 + cos1 * 0x60;
                    g += 0x80;
                    b += 0x10 + sin1 * 0x10;
                    
                    if( r > 0xff ) r = 0xff;
                    if( g > 0xff ) g = 0xff;
                    if( b > 0xff ) b = 0xff;
                    
                    screen.setPixel( p.x, p.y, (r<<0x10)|(g<<0x08)|b );
                }
                
                p = p.next;
                
            } while(p);
        }
    }
}


dynamic class Particle 
    {
        public var next: Particle;       
        public var x: Number;
        public var y: Number;       
        public var vx: Number;
        public var vy: Number;
        
//TweenMax.to(root.stage, 1, {x:mouseX, y:mouseY, ease:Quad.easeOut});         
    }
