/**
 * Copyright HAL8 ( http://wonderfl.net/user/HAL8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mSyz
 */

// forked from ProjectNya's AquaBall
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] Aquaクラスに挑戦！
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1064
// special thanks to hedgehog
////////////////////////////////////////////////////////////////////////////////

package {

	import flash.display.Sprite;

	[SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

	public class Main extends Sprite {
		private var aqua:Aqua;
		private var wheel:Wheel;

		public function Main() {
			//Wonderfl.capture_delay(1);
			init();
		}

		private function init():void {
			aqua = new Aqua(100, 230);
			addChild(aqua);
			aqua.x = 232;
			aqua.y = 392;
			var wheel:Wheel = new Wheel();
			wheel.x = 420;
			wheel.y = 420;
			addChild(wheel);
			wheel.init({zero: 0, angle :230});
			wheel.addEventListener(CompoEvent.CHANGE, change, false, 0, true);
		}
		private function change(evt:CompoEvent):void {
			aqua.colorize(evt.value);
		}

	}

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import frocessing.color.ColorHSV;

class Aqua extends Sprite {
	private var radius:uint;
	private var hue:Number;
	private var light:Shape;
	private var inner:Shape;
	private var base:Shape;
	private var shade:Shape;
	private static var bColor:uint = 0xFFFFFF;
	private static var sColor:uint = 0x000000;
	private var shaded:Boolean;

	public function Aqua(r:uint, h:Number, s:Boolean = true) {
		radius = r;
		hue = h;
		shaded = s;
		draw();
	}

	private function draw():void {
		if (shaded) {
			shade = new Shape();
			addChild(shade);
			createShade();
		}
		base = new Shape();
		addChild(base);
		base.y = -radius;
		inner = new Shape();
		addChild(inner);
		inner.y = -radius;
		light = new Shape();
		addChild(light);
		light.y = -radius;
		createLight();
		colorize(hue);
	}
	public function colorize(h:Number):void {
		h %= 360;
		if (h < 0) h += 360;
		hue = Math.floor(h);
		createBase();
		createInner();
	}
	private function createBase():void {
		base.graphics.clear();
		//var color:Number = ColorConversion.HSBtoHEX24(hue, 75, 78);
		var hsv:ColorHSV = new ColorHSV(hue, 0.75, 0.78);
		base.graphics.beginFill(hsv.value);
		base.graphics.drawCircle(0, 0, radius);
		base.graphics.endFill();
		var _hue:Number = (hue + 6)%360;
		//var gColor:Number = ColorConversion.HSBtoHEX24(_hue, 50, 53);
		var ghsv:ColorHSV = new ColorHSV(hue, 0.5, 0.53);
		var glow:GlowFilter = new GlowFilter(ghsv.value, 1, radius*0.5, radius*0.5, 2, 3, true, false);
		base.filters = [glow];
	}
	private function createShade():void {
		shade.graphics.beginFill(sColor);
		shade.graphics.drawEllipse(-radius*0.75, -radius*0.1775, radius*1.5, radius*0.375);
		shade.graphics.endFill();
		var shadow:DropShadowFilter = new DropShadowFilter(0, 90, sColor, 0.5, radius*0.15, radius*0.15, 1, 3, false, false, true);
		shade.filters = [shadow];
	}
	private function createLight():void {
		var colors:Array = [bColor, bColor];
		var alphas:Array = [0.7, 0];
		var ratios:Array = [0, 191];
		var matrix:Matrix = new Matrix();
		var w:Number = radius*1.44;
		var h:Number = radius*1.35;
		var yOffset:Number = radius*0.95;
		matrix.createGradientBox(w, h, 0.5*Math.PI, -w*0.5, -yOffset);
		light.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
		light.graphics.drawEllipse(-w*0.5, -yOffset, w, h);
		light.graphics.endFill();
	}
	private function createInner():void {
		inner.graphics.clear();
		var colors:Array = [bColor, bColor];
		var alphas:Array = [1, 0];
		var ratios:Array = [0, 191];
		var matrix:Matrix = new Matrix();
		var w:Number = radius*1.44;
		var h:Number = radius*1.35;
		var yOffset:Number = radius*0.45;
		matrix.createGradientBox(w, h, -0.5*Math.PI, -w*0.5, -yOffset);
		inner.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
		inner.graphics.drawEllipse(-w*0.5, -yOffset, w, h);
		inner.graphics.endFill();
		var colorTrans:ColorTransform = new ColorTransform();
		var _hue:Number = (hue - 30)%360;
		if (_hue < 0) _hue += 360;
		//var color:Number = ColorConversion.HSBtoHEX24(_hue, 100, 100);
		var color:ColorHSV = new ColorHSV(hue, 1, 1);
		colorTrans.color = color.value;
		inner.transform.colorTransform = colorTrans;
		var b:Number = radius*0.15;
		var blur:BlurFilter = new BlurFilter(b, b, 3);
		inner.filters = [blur];
	}

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.DropShadowFilter;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class Wheel extends Sprite {
	private var base:Sprite;
	private var thumb:Sprite;
	private var point:Shape;
	private var hit:Shape;
	private static var bColor:uint = 0xFFFFFF;
	private static var cColor:uint = 0x999999;
	private static var sColor:uint = 0x000000;
	private static var pColor:uint = 0x666666;
	private static var offColor:uint = 0xCCCCCC;
	private static var cColorTrans:ColorTransform;
	private static var pColorTrans:ColorTransform;
	private static var offColorTrans:ColorTransform;
	private var zero:Number = 0;
	private var angle:Number = 0;
	private var shade:DropShadowFilter;
	private var initValue:Number;
	private var value:Number;
	private var _enabled:Boolean = true;

	public function Wheel() {
	}

	public function init(option:Object):void {
		if (option.zero != undefined) zero = option.zero;
		if (option.angle != undefined) angle = option.angle;
		value = initValue = angle;
		draw();
	}
	private function draw():void {
		shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false);
		cColorTrans = new ColorTransform();
		cColorTrans.color = cColor;
		pColorTrans = new ColorTransform();
		pColorTrans.color = pColor;
		offColorTrans = new ColorTransform();
		offColorTrans.color = offColor;
		base = new Sprite();
		thumb = new Sprite();
		point = new Shape();
		hit = new Shape();
		addChild(base);
		base.addChild(thumb);
		thumb.addChild(point);
		thumb.addChild(hit);
		addChild(thumb);
		base.x = thumb.x = 0;
		base.y = thumb.y = 0;
		createDonut(base, 30, 10);
		base.filters = [shade];
		point.x = 20;
		createCircle(point, 5, bColor, 1);
		hit.x = 20;
		createCircle(hit, 10, bColor, 0);
		reset();
		_up();
		enabled = true;
		thumb.mouseChildren = false;
	}
	private function rollOver(evt:MouseEvent):void {
		_over();
	}
	private function rollOut(evt:MouseEvent):void {
		_up();
	}
	private function press(evt:MouseEvent):void {
		_down();
		thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
		stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
		stage.addEventListener(MouseEvent.MOUSE_MOVE, change, false, 0, true);
		stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
	}
	private function release(evt:MouseEvent):void {
		_up();
		checkValue();
		var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
		dispatchEvent(e);
		thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
		stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
		stage.removeEventListener(Event.MOUSE_LEAVE, leave);
	}
	private function releaseOutside(evt:MouseEvent):void {
		_up();
		checkValue();
		var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
		dispatchEvent(e);
		thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
		stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
		stage.removeEventListener(Event.MOUSE_LEAVE, leave);
	}
	private function leave(evt:Event):void {
		_up();
		checkValue();
		var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
		dispatchEvent(e);
		thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
		stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
		stage.removeEventListener(Event.MOUSE_LEAVE, leave);
	}
	private function _up():void {
		point.transform.colorTransform = cColorTrans;
	}
	private function _over():void {
		point.transform.colorTransform = pColorTrans;
	}
	private function _down():void {
		point.transform.colorTransform = pColorTrans;
	}
	private function _off():void {
		point.transform.colorTransform = offColorTrans;
	}
	private function change(evt:MouseEvent):void {
		_down();
		thumb.rotation = Math.round(Math.atan2(base.mouseY, base.mouseX)/Math.PI*180);
		evt.updateAfterEvent();
		checkValue();
		var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, value);
		dispatchEvent(e);
	}
	private function checkValue():void {
		value = (thumb.rotation + 360 + 90 - zero)%360;
	}
	public function get enabled():Boolean {
		return _enabled;
	}
	public function set enabled(param:Boolean):void {
		_enabled = param;
		if (!_enabled) _off();
		thumb.buttonMode = _enabled;
		thumb.mouseEnabled = _enabled;
		thumb.useHandCursor = _enabled;
		if (_enabled) {
		thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
		thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
		thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
		} else {
		thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
		thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
		thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
		}
	}
	public function reset():void {
		value = initValue;
		thumb.rotation = value - 90 + zero;
	}
	private function createCircle(target:Shape, r:uint, color:uint, alpha:Number):void {
		target.graphics.beginFill(color, alpha);
		target.graphics.drawCircle(0, 0, r);
		target.graphics.endFill();
	}
	private function createDonut(target:Sprite, outer:uint, inner:uint):void {
		target.graphics.beginFill(bColor);
		target.graphics.drawCircle(0, 0, outer);
		target.graphics.drawCircle(0, 0, inner);
		target.graphics.endFill();
	}

}


import flash.events.Event;

class CompoEvent extends Event {
	public static const SELECT:String = "select";
	public static const CHANGE:String = "change";
	public var value:*;

	public function CompoEvent(type:String, value:*) {
		super(type);
		this.value = value;
	}

	public override function clone():Event {
		return new CompoEvent(type, value);
	}

}
