/**
 * Copyright hacker_rs10vazy ( http://wonderfl.net/user/hacker_rs10vazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mSqQ
 */

// forked from FlashBum's forked from: Pseudo 3D Push Button Decorator
// forked from FlashBum's Pseudo 3D Push Button Decorator
package {

	import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
 
    /**
      * author Jesse Freeman aka @theFlashBum | http://jessefreeman.com
      * 
      * This is a simple demo of how to create a "3d Push Button" similar
      * to the new UI on wp7 phones. Noting fancy here but I do add the
      * notion of force so depending on where you press the button it will
      * rotate farther.
      * 
 	  * Since this is a decorator (see internal class) it can be applied
 	  * to any button (as long as you are compiling for FP 10.0).
      * 
      * It is important to note that the rotation will be "off" based on
      * the center position of the box.
      *
      */
      
public class ButtonTest extends Sprite {

    private var decorator:PushButtonDecorator = new PushButtonDecorator();
        private var display:Sprite;

        public function ButtonTest() {

            configureStage();
            init();
        }

        protected function configureStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }


        protected function init():void
        {
            createDisplay();

            createButtonGid();
        }

        private function createDisplay():void {
            display = addChild(new Sprite()) as Sprite;
            display.x = 15;
            display.y = 30;
            display.addEventListener(MouseEvent.CLICK, onClick);
        }

        private function createButtonGid():void {
            var nextX:Number = 0;
            var nextY:Number = 0;
            var total:Number = 4;
            var padding:Number = 10;
            var maxPerColumn:Number = 2;
            var i:int = 0;
            var tempButton:Sprite;

            for (i = 0; i < total; i ++)
            {
                tempButton = display.addChild(createButton()) as Sprite;
                tempButton.x = nextX;
                tempButton.y = nextY;

                nextX += tempButton.width + padding;


                if ((i % maxPerColumn) == 1)
                {
                    nextX = 0;
                    nextY += tempButton.height + padding;
                }

            }
        }

        private function onClick(event:MouseEvent):void {

            var target:DisplayObject = event.target as DisplayObject;

            trace(target);

            decorator.target = target;
            decorator.push(event.localX / target.width);
        }

        private function createButton():Sprite {

            var button:Sprite = new Sprite();
            button.graphics.beginFill(Math.random() * 0xFFFFFF);
            button.graphics.drawRect(0, 0, 100, 100);
            button.graphics.endFill();

            button.buttonMode = true;
            button.useHandCursor = true;

            return button;
        }
	}
}

	import caurina.transitions.*;

    import flash.display.DisplayObject;

    internal class PushButtonDecorator {

        private var _target:DisplayObject;

        public function PushButtonDecorator(target:DisplayObject = null) {
            if(target)_target = target;
        }

        public function get target():DisplayObject {
            return _target;
        }

        public function set target(value:DisplayObject):void {
            _target = value;
        }
        
        public function push(force:Number = 1):void {

            var rotY:Number = -30 * force;

            Tweener.addTween(_target, {time:.2, rotationY: rotY, overwrite: 0, onComplete:reset});

        }

        public function reset(delay:Number = 0):void
        {
            Tweener.addTween(_target, {time:.2, rotationY: 0, overwrite: 0, delay:delay});    
        }


    }