/**
 * Copyright Horiuchi_H ( http://wonderfl.net/user/Horiuchi_H )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mSge
 */

package 
{
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.ColorTransform;
	import flash.text.*;
	import flash.utils.Timer;
	
	[SWF(width = 140, height = 80, backgroundColor = 0xCCCCCC, frameRate = 30)]
	
	public class BinaryClock extends Sprite 
	{
		private const UNIT_LENGTH:int = 20;
		
		private var hourPoints:Vector.<Sprite> = new Vector.<Sprite>();
		private var minutePoints:Vector.<Sprite> = new Vector.<Sprite>();
		private var secondPoints:Vector.<Sprite> = new Vector.<Sprite>();
		private var timeTexts:Vector.<TextField> = new Vector.<TextField>();
		
		public function BinaryClock():void {
			init();
		}
		
		private function init():void {
			
			(function(points:Vector.<Sprite>):void {
				for (var index:int = 0; index < 5; index++) {
					var point:Sprite = createPoint();
					point.x = index * UNIT_LENGTH + UNIT_LENGTH;
					point.y = 0;
					points.push(point);
				}
			})(hourPoints);
			var initPoints:Function = function(points:Vector.<Sprite>, y:int):void {
				for (var index:int = 0; index < 6; index++) {
					var point:Sprite = createPoint();
					point.x = index * UNIT_LENGTH;
					point.y = y;
					points.push(point);
				}
			}
			initPoints(minutePoints, UNIT_LENGTH);
			initPoints(secondPoints, UNIT_LENGTH * 2);
			
			(function(fields:Vector.<TextField>):void {
				for (var index:int = 0; index < 3; index++) {
					var field:TextField = new TextField();
					field.width = UNIT_LENGTH;
					field.height = UNIT_LENGTH;
					field.x = UNIT_LENGTH * 6;
					field.y = index * UNIT_LENGTH;
					field.autoSize = TextFieldAutoSize.CENTER;
					timeTexts.push(field);
				}
			})(timeTexts);
			
			var format:TextFormat = new TextFormat();
			format.color = 0x999999;
			(function():Vector.<TextField> {
				var result:Vector.<TextField> = new Vector.<TextField>();
				for (var index:int = 0; index < 6; index++) {
					var field:TextField = new TextField();
					field.width = UNIT_LENGTH;
					field.height = UNIT_LENGTH / 2;
					field.x = UNIT_LENGTH * (5 - index);
					field.y = 3 * UNIT_LENGTH;
					field.autoSize = TextFieldAutoSize.CENTER;
					field.text = String(Math.pow(2, index));
					field.setTextFormat(format);
					result.push(field);
				}
				return result;
			})().map(function(field:TextField, i:int, a:*):void {
				addChild(field);
			});
			
			hourPoints = hourPoints.reverse();
			for each (var hp:Sprite in hourPoints) {
				addChild(hp);
			}
			minutePoints = minutePoints.reverse();
			for each (var mp:Sprite in minutePoints) {
				addChild(mp);
			}
			secondPoints = secondPoints.reverse();
			for each (var sp:Sprite in secondPoints) {
				addChild(sp);
			}
			for each (var field:TextField in timeTexts) {
				addChild(field);
			}
			
			var timer:Timer = new Timer(500);
			timer.addEventListener(TimerEvent.TIMER, setBinaryTime);
			timer.start();
		}

		private function createPoint():Sprite
		{
			var point:Sprite = new Sprite();
			point.graphics.beginFill(0xFFFFFF, 0.6);
			point.graphics.drawRoundRect(0, 0, UNIT_LENGTH, UNIT_LENGTH, UNIT_LENGTH / 2.0, UNIT_LENGTH / 2.0);
			point.graphics.endFill();
			return point;
		}
		
		private function setBinaryTime(event:TimerEvent):void
		{
			var now:Date = new Date();
			
			([now.hours, now.minutes, now.seconds]).forEach(function(value:int, index:int, a:*):void {
				timeTexts[index].text = ((value < 10)? "0": "") + value;
			});

			var changeColorTime:Function = function(points:Vector.<Sprite>, value:int):void {
				for (var index:int = 0; index < points.length; index++) {
					var mask:int = (1 << index);
					changeColor(points[index], (~value & mask) >> index);
				}
			}
			changeColorTime(hourPoints, now.hours);
			changeColorTime(minutePoints, now.minutes);
			changeColorTime(secondPoints, now.seconds);
		}
		
		private function changeColor(s:Sprite, i:Number):void
		{
			s.transform.colorTransform = new ColorTransform(i, i, i, 1, 1, 1, 1, 0);
		}
	}
}
