/**
 * Copyright MMMMMonchi ( http://wonderfl.net/user/MMMMMonchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mRuP
 */

// forked from jmk2's forked from: プロとして恥ずかしくないActionScript3.0 メモ サンプル
// forked from albatrus_jp's プロとして恥ずかしくないActionScript3.0 メモ サンプル
package {
    import flash.display.*;
    import flash.display.DisplayObject;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Rectangle;
    import flash.events.Event;

    public class DragDrop extends Sprite {
        // ドラッグ中フラグ
        private var m_bDragging:Boolean = false;
        // ドラッグ可能オブジェクト
        private var m_object:Sprite;
        // ダブルクリック判定フラグ
        private var m_bDoubleClick:Boolean = false;
        // マウスボタン押下中フラグ
        private var m_bMouseDown:Boolean = false;
        // カラーリスト
        private var m_color:Array = [
            0xc85051,
            0xe88949,
            0xe2af46,
            0xdbd237,
            0xadc13c,
            0x3fad4c,
            0x56c6a5,
            0x47b9d1,
            0x4d90bf,
            0x617cc0,
            0x898acd
        ];

        /**
          * コンストラクタ
          */
        public function DragDrop( ) {
            // ドラッグ可能オブジェクトの作成
            m_object = create(50);
            m_object.x = 275;
            m_object.y = 200;
            m_object.doubleClickEnabled = true;        // ダブルクリック許可

            addChild(m_object);

            m_object.addEventListener(MouseEvent.CLICK, clickHandler);
            m_object.addEventListener(MouseEvent.DOUBLE_CLICK, doubleClickHandler);
            m_object.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            m_object.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            m_object.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);

            // 画面外マウスボタンアップ対策
            stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutsideHandler);
        }
        /**
          * グラデーションの掛かった円の作成（表示オブジェクト）
          */
        private function create(radius:Number):Sprite {
            var object:Sprite = new Sprite();
            var step:Number = 255.0 / radius;

            for(var i:int = 0; i < radius; i++) {
                var col:uint = step * i ;
                var color:uint = col << 16 | col;

                object.graphics.beginFill(color);
                object.graphics.drawCircle(0, 0, radius - i);
                object.graphics.endFill();
            }
            return object;
        }
        /**
          * マウスボタンシングルクリック処理
          */
        private function clickHandler(event:MouseEvent):void {
            callDelay(180, function():void {
                if(m_bDoubleClick) {
                    // ダブルクリック処理
                    createRipple(2);
                } else {
                    if(m_bDragging == false) {
                        // シングルクリック処理
                        createRipple(1);
                    }
                    m_bDragging = false;
                }
            });
            m_bDoubleClick = false;
        }
        /**
          * マウスボタンダブルクリック処理
          */
        private function doubleClickHandler(event:MouseEvent):void {
            m_bDoubleClick = true;
        }
        /**
          * マウス移動処理
          */
        private function mouseMoveHandler(event:MouseEvent):void {
            if(m_bMouseDown) {
                // ドラッグ範囲
                var bounds:Rectangle = new Rectangle(50, 50, 450, 300);

                m_bDragging = true;

                // 範囲を指定して、ドラッグ処理開始
                event.target.startDrag(false, bounds);
                // ドロップシャドウ開始（背景が白い場合に使用してみてください）
//                event.target.filters = [
//                    new DropShadowFilter( 8.0, 45, 0x000000, 0.75, 8.0, 8.0, 1.0)
//                ];
                // ドラッグ中表現処理
                m_object.addEventListener(MouseEvent.MOUSE_MOVE, rippleHandler);
            }
        }
        /**
          * マウスボタン解除処理
          */
        private function mouseUpHandler( event:MouseEvent ):void {
            stopDragging(Sprite(event.target));
        }
        /**
          * マウスボタン押下処理
          */
        private function mouseDownHandler( event:MouseEvent ):void {
            m_bMouseDown = true;
        }
        /**
          * 画面外でマウスを離した
          */
        private function releaseOutsideHandler(event:MouseEvent):void {
            if(m_bDragging) {
                stopDragging(m_object);
            }
        }
        /**
          * ドラッグ停止処理
          */
        private function stopDragging(target:Sprite):void {
            m_bMouseDown = false;
            // ドラッグ処理終了
            target.stopDrag( );
            // ドロップシャドウ終了（背景が白い場合に使用してみてください）
//            target.filters = null;

            m_object.removeEventListener(MouseEvent.MOUSE_MOVE, rippleHandler);
        }
        /**
          * 指定時間待ってから関数を実行する
          */
        private function callDelay(delay:Number, func:Function):void {
            var timer:Timer = new Timer(delay, 1);

            timer.addEventListener(TimerEvent.TIMER_COMPLETE, function(event:TimerEvent):void {
                event.target.removeEventListener(event.type, arguments.callee);
                timer.stop();
                func();
            });
            timer.start();
        }
        /**
          * 整数値の乱数を作成する
          */
        private function intRandom(min:int, max:int):int {
            return Math.floor(Math.random() * (max - min + 1)) + min;
        }
        /**
          * 乱数により波紋を作成する
          */
        private function rippleHandler(event:MouseEvent):void {
            createRipple(intRandom(0, 2));
        }
        /**
          * 指定数の波紋を作成する
          */
        private function createRipple(num:int):void {
            for (var i:uint=1; i<=num; i++) {
                var ripple:Sprite = makeRipple(m_object);

                addChild(ripple);

                drawRipple(ripple, i);
            }
        }
        /**
          * 波紋の作成
          */
        private function makeRipple(object:Sprite):Sprite {
            //表示オブジェクトの作成とコンテナへの登録
            var sp:Sprite = new Sprite();

            sp.x = object.x;
            sp.y = object.y;

            //イベント設定
            sp.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            return sp;
        }
        /**
          * 波紋の描画
          */
        private function drawRipple(sp:Sprite, num:int):void {
            var thickness:uint=1;
            var color:uint = m_color[intRandom(0, 10)];
            var alpha:Number=1.0;
            var pixelHinting:Boolean = false;
            var scaleMode:String = "none";
            var cr:Number = 50 + intRandom(0, 10);

            sp.graphics.lineStyle(thickness, color, alpha, pixelHinting, scaleMode);
            sp.graphics.drawCircle(0, 0, cr);
        }
        /**
          * フレーム再生イベント
          */
        private function enterFrameHandler(event:Event):void {
            var sp:Sprite = event.target as Sprite;

            if (sp.alpha > 0) {                // 波紋の透明度とサイズを変更
                sp.scaleX += 0.1;
                sp.scaleY += 0.1;
                sp.alpha -= 0.03;
            } else {                            // 透明になった波紋を削除
                sp.graphics.clear();
                sp.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
                removeChild(sp);
            }
        }
    }
}