/**
 * Copyright pon_zu ( http://wonderfl.net/user/pon_zu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mR8g
 */

package 
{
	import flash.display.*;
	import flash.events.Event;
	/**
	 * ...
	 * @author harada
	 */
	public class Main extends Sprite 
	{
		private var _bullets:Array;
		private const BULLETS_MAX:int = 100;
		
		public function Main():void 
		{	
			_bullets = new Array();
			for (var i:int = 0; i < BULLETS_MAX; i++)
			{
				var radius:int = Math.round(Math.random() * 20) + 10;
				var fillColor:uint = Math.round(Math.random() * 0xffffff);
				var xIni:int = Math.random() * stage.stageWidth;
				var yIni:int = Math.random() * stage.stageHeight;
				var vx:Number = xIni * 0.01;
				var vy:Number = yIni * 0.01;
				
				var bullet:Bullet = new Bullet(radius, fillColor, xIni, yIni);
				addChild(bullet);
				_bullets.push(bullet);
			}
			
			// フレームごとに実行する処理にenterFrameHandler()を追加する。
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		public function enterFrameHandler(e:Event):void
		{	
			for (var i:int = 0; i < BULLETS_MAX; i++)
			{
				_bullets[i].move();
				if (_bullets[i].displayOut())
				{	
					removeChild(_bullets[i]);
					_bullets.splice(i--, 1);
				}
			}
		}
	}
	
}
 
import flash.display.Sprite;
 
class Bullet extends Sprite
{
	public function Bullet(color:int, radius:int, x:int, y:int)
	{
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
 
		this.x = x;
		this.y = y;
	}
 
	public function move():void
	{
		this.x += 3;
		this.y += 2;
	}
 
	public function check():Boolean
	{
		if (x < -50 || stage.stageWidth  + 50 < x ||
			y < -50 || stage.stageHeight + 50 < y)
		{
			return true;
		}
 
		return false;
	}
}