/**
 * Copyright ameo ( http://wonderfl.net/user/ameo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mQLF
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;

    [SWF(width = 300, height = 300, frameRate = 60)]

    public class MicExam extends BasicView {
        private var mic:Microphone;
        private var sphere:Sphere;

        public function MicExam() {
            // 背景を黒に設定
            viewport.opaqueBackground = 0x000000;
            //マイク
            mic = Microphone.getMicrophone();
            if (mic != null) {
                mic.gain = 15;
                mic.setUseEchoSuppression(true);
                mic.setLoopBack(true);
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            // 球体を作成
            var material:WireframeMaterial = new WireframeMaterial(0x0099FF);
            sphere = new Sphere(material, 800, 20, 20);
            scene.addChild(sphere);

            }
            // レンダリング
            startRendering();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(e:Event):void {

            // 球体のスケールを制御
            sphere.scale -= 0.01;
            sphere.scale = Math.max(mic.activityLevel*0.01,sphere.scale);
            
            // 球体の回転を制御
            sphere.rotationX += Math.max(mic.activityLevel) *2;
            sphere.rotationY += Math.max(mic.activityLevel) *4;
        }

    }
}