/**
 * Copyright Cao ( http://wonderfl.net/user/Cao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mPXW
 */

package{
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.system.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.filters.*;

    [SWF(width="640", height="480")]

    public class Threshold2 extends Sprite {
    private var video:Video;
    private var camera:Camera;
    private var msg:String;
    public var txtArea:TextField = new TextField();
    public var bdTmp:BitmapData;
    public var bmp:Bitmap;

    public function Threshold2()
    {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;

        // (1)
        camera = Camera.getCamera();
        if(camera != null){
        camera.addEventListener(StatusEvent.STATUS, statusHandler);
        camera.setMode(640, 480, 15);
        camera.setMotionLevel(10);
        camera.setQuality(0, 50);

        // (2)
        video = new Video(camera.width, camera.height);
        video.attachCamera(camera);

        addEventListener(Event.ENTER_FRAME, tick);
        }else{
        msg = "使用可能なカメラがありません。";
        txtArea.text = msg;
        }

        txtArea.autoSize = TextFieldAutoSize.LEFT;
        txtArea.text = "Threshold";
        txtArea.textColor = 0xffffff;
        txtArea.x = 2;
        txtArea.y = this.height - txtArea.textHeight - 10;
        this.addChild(txtArea);

        // (3)
        bdTmp = new BitmapData(video.width, video.height, false, 0xffffff);
        bmp = new Bitmap(bdTmp);
        this.addChild(bmp);
    }

    private function statusHandler(evt:StatusEvent):void{
        if(camera.muted){
        msg = "カメラへのアクセスが拒否されました。";
        msg += "カメラの映像を表示するにはアクセスを許可してください。";
        txtArea.text = msg;
        Security.showSettings(SecurityPanel.PRIVACY);
        }else{
        msg = "使用中のカメラ : " + camera.name + "\n";
        msg += "幅x高さ : " + camera.width + "x" + camera.width;
        txtArea.text = msg;
        }
    }

    private function tick(event:Event):void{
        if(video == null || camera == null){
        return;
        }
        if(camera.muted == true){
        return;
        }
        // (4)
        var s:BitmapData = new BitmapData(video.width, video.height);
        s.draw(video);

        // (5)
        var r:Rectangle = new Rectangle(0, 0, video.width, video.height);
        bdTmp.fillRect(r, 0xffffffff);

        // (6)
        var threshold:uint = 0x00800000;
        var color:uint =0xFFC702;
        var maskColor:uint = 0x00ff0000;
        bdTmp.threshold(s, r, new Point(0, 0), "<=", threshold, color, maskColor, false);
    }
    }
}