/**
 * Copyright mirrorboy ( http://wonderfl.net/user/mirrorboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mPUS
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    import idv.cjcat.stardust.common.*;
    import idv.cjcat.stardust.common.actions.ActionCollection;
    import idv.cjcat.stardust.common.actions.Age;
    import idv.cjcat.stardust.common.actions.DeathLife;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.initializers.Life;
    import idv.cjcat.stardust.common.math.UniformRandom;
    import idv.cjcat.stardust.common.renderers.Renderer;
    import idv.cjcat.stardust.twoD.*;
    import idv.cjcat.stardust.twoD.actions.Accelerate;
    import idv.cjcat.stardust.twoD.actions.Move;
    import idv.cjcat.stardust.twoD.emitters.Emitter2D;
    import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
    import idv.cjcat.stardust.twoD.initializers.Velocity;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
    import idv.cjcat.stardust.twoD.zones.LazySectorZone;
    
    public class StarDustTest extends Sprite
    {
        private var emitter:Emitter2D;
        private var renderer:Renderer;
        
        public function StarDustTest()
        {
            var mc:MovieClip = new MovieClip;
            mc.x = mc.y = 200;
            addChild(mc);
            
            //clock生成
            var clock:SteadyClock = new SteadyClock(1);
            emitter = new Emitter2D(clock);
            renderer = new DisplayObjectRenderer(mc);
            renderer.addEmitter(emitter);
        
            //イニシャライザー登録
            emitter.addInitializer(new DisplayObjectClass(MyCircle));
            emitter.addInitializer(new Velocity(new LazySectorZone(Math.random(),0)));
            emitter.addInitializer(new Life(new UniformRandom(100, 0)));
            
            emitter.addAction(new Age()); //寿命を有効化
            emitter.addAction(new DeathLife()); //キエル
            emitter.addAction(new Accelerate(0.8)); ///加速
            emitter.addAction(new Move());//移動
            
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void{
            emitter.step();
        }
    }
}

import flash.display.*;

class MyCircle extends Sprite{
    
    
    public function MyCircle(){
        var rectSize:Number = Math.random() * 30;
        
        
        graphics.beginFill(0x880000);
        graphics.drawCircle(0,0,rectSize+0.5);
        graphics.beginFill(0xCC0000);
        graphics.drawCircle(0,0,rectSize);
        graphics.beginFill(0xEE0000);
        graphics.drawCircle(0,0,rectSize/2.);
    }
}