/**
 * Copyright takuya1021 ( http://wonderfl.net/user/takuya1021 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mP27
 */

// forked from RobotCaleb's Fractal Tree
package
{
	import flash.display.Sprite;
	import flash.display.StageScaleMode;

	[SWF(width="400", height="400", backgroundColor="#d1d1d1")]
	public class Fractal extends Sprite
	{
                 private const MAXSTEPS:Number = 10;
                private const angleLeft:Number = Math.PI/180*20;
                private const angleRight:Number = Math.PI/180*50;
                private const lengthMult:Number = 0.7;
                
		public function Fractal()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			DrawFractal();
		}
	
		public function DrawFractal():void
		{
                        var angle:Number = Math.PI / 180 * 90;
			DrawPiece(angle, 200, 400, 100, 0);
		}
		
		public function DrawPiece(angle:Number, x:Number, y:Number, length:Number, count:Number):void
		{
			if (count < MAXSTEPS)
			{
				var newLength:Number = length * lengthMult;
                                var newX:Number = x - Math.cos(angle) * length;
				var newY:Number = y - Math.sin(angle) * length;
				
			        graphics.lineStyle(0, 0xff000000);
				graphics.moveTo(x, y);
				graphics.lineTo(newX, newY);
				
				DrawPiece(angle + angleRight, newX, newY, newLength, count + 1);
				DrawPiece(angle - angleLeft, newX, newY, newLength, count + 1);
			}
		}
	}
}