/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mP09
 */

// forked from _wonder's セグメントを描画：IK drag (1)
/*
* クリックすると段階的にリーチします。（1秒毎に動きます）
*/

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.setInterval;
    import flash.utils.clearInterval;
    
    public class InverseKinematics extends Sprite
    {
        private var seg0:Segment;
        private var seg1:Segment;
        private var seg2:Segment;
        private var tx:Number;
        private var ty:Number;
        private var num:uint = 1;
        private var iv:Number;
        
        public function InverseKinematics() 
        {
            seg0 = new Segment( 60, 20, 0xccff00 );
            seg0.x = stage.stageWidth / 2;
            seg0.y = stage.stageHeight / 2
            addChild( seg0 );
            
            seg1 = new Segment( 60, 20, 0xcc0000 );
            seg1.x = stage.stageWidth / 2;
            seg1.y = stage.stageHeight / 2
            addChild( seg1 );
            
            seg2 = new Segment( 60, 20, 0xffcc00 );
            seg2.x = stage.stageWidth / 2;
            seg2.y = stage.stageHeight / 2
            addChild( seg2 );
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function interval():void {
            if ( num < 6 ) {
                this["reach0" + num]();
                num++;
            } else {
                clearInterval( iv );
                num = 1;
                trace("clear");
            }
        }
        
        private function onClick(e:MouseEvent):void {
            if ( iv ) clearInterval( iv );
            iv = setInterval(interval, 1000);
        }
        
        private function reach01():void {
            /* seg0 */
            var dx:Number = mouseX - seg0.x;
            var dy:Number = mouseY - seg0.y;
            var angle:Number = Math.atan2( dy, dx );
            seg0.rotation = angle * 180 / Math.PI;
            
            var w:Number = seg0.getPin().x - seg0.x;
            var h:Number = seg0.getPin().y - seg0.y;
            tx = mouseX - w;
            ty = mouseY - h;
        }
        
        private function reach02():void {
            /* seg1 */
            var dx:Number = tx - seg1.x;
            var dy:Number = ty - seg1.y;
            var angle:Number = Math.atan2( dy, dx );
            seg1.rotation = angle * 180 / Math.PI;
            
            var w:Number = seg1.getPin().x - seg1.x;
            var h:Number = seg1.getPin().y - seg1.y;
            tx = tx - w;
            ty = ty - h;
        }
        
        private function reach03():void {
            /* seg2 */
            var dx:Number = tx - seg2.x;
            var dy:Number = ty - seg2.y;
            var angle:Number = Math.atan2( dy, dx );
            seg2.rotation = angle * 180 / Math.PI;
            
            seg2.x = stage.stageWidth / 2;
            seg2.y = stage.stageHeight / 2;
        }
        
        private function reach04():void {
            seg1.x = seg2.getPin().x;
            seg1.y = seg2.getPin().y;
        }
        
        private function reach05():void {
            seg0.x = seg1.getPin().x;
            seg0.y = seg1.getPin().y;
        }
        
    }

}

import flash.display.Sprite;
import flash.geom.Point;

class Segment extends Sprite {
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number,segmentHeight:Number,color:uint=0xffffff){
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        init();
    }
    
    public function init():void {
        //セグメントの描画
        graphics.lineStyle( 0 );
        graphics.beginFill( color );
        graphics.drawRoundRect( -segmentHeight / 2, -segmentHeight / 2, segmentWidth+segmentHeight, segmentHeight, segmentHeight, segmentHeight );
        graphics.endFill();
        
        //ピン
        graphics.drawCircle( 0, 0, 2 );
        
        graphics.lineStyle( 0, 0xcc0000 );
        graphics.beginFill( 0xcc0000 );
        graphics.drawCircle( segmentWidth, 0, 2 );
    }
    
    public function getPin():Point {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos( angle ) * segmentWidth;
        var yPos:Number = y + Math.sin( angle ) * segmentWidth;
        return new Point( xPos, yPos );
    }
}