/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mO4Q
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _data:/*Datum*/Array;
		
        public function FlashTest() {
			_data = new Array();
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			for (var i:uint = 0; i < 3; ++i) {
				var datum:Datum = new Datum();
				datum.angle = Math.random() * Math.PI * 2;
				datum.length = 350;
				var cr:uint = Math.random() * 256;
				var cg:uint = Math.random() * 256;
				var cb:uint = Math.random() * 256;
				datum.color = (cr << 16) + (cg << 8) + (cb << 0);
				datum.size = 1 + (Math.random() * 4);
				datum.speed = 0.5 + (Math.random() * 1);
				_data.push(datum);
			}
			
			var g:Graphics = this.graphics;
			g.clear();
			for (var index:uint = 0; index < _data.length; ++index) {
				var d:Datum = _data[index];
				
				if (d.length < 1) {
					_data.splice(index, 1);
					--index;
					continue;
				}

				d.length *= 0.99;
				d.size *= 0.99;
				d.angle += Math.PI * 0.005 * datum.speed * datum.size;
				
				if (d.angle > Math.PI * 2) d.angle -= Math.PI * 2;
				
				g.beginFill(d.color);
				g.drawCircle(232.5 + Math.cos(d.angle) * d.length, 232.5 + Math.sin(d.angle) * d.length, d.size);
				g.endFill();
			}
		}
    }
}

class Datum {
	public var angle:Number;
	public var length:Number;
	public var color:uint;
	public var size:Number;
	public var speed:Number;
}