/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mNLN
 */

package {
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.utils.*;
    
    public class ScopeTest extends Sprite {
        
        private const WIDTH: uint = 400;
        private const HEIGHT: uint = 400;
        private const FULL_SIZE: Rectangle = new Rectangle(0,0,WIDTH,HEIGHT);
        private const BG: uint = 0xFFFFFFFF;
        
        private var _tf:TextField;
        private var _test2: Test;
        
        public var blah: String = "root"
        
        public function ScopeTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addChild( _tf = new TextField() );
            var f:TextFormat =  new TextFormat("Verdana", 10);
            f.tabStops = [20, 100, 245, 350, 475];
            _tf.defaultTextFormat = f;
            _tf.width = stage.stageWidth;
            _tf.height = stage.stageHeight;
            
            _test2 =  new Test();
            _test2.blah = "instance";
            
            runTest( "instance", new Test().doIt );
            runTest( "custom delegate", function( arg: String ="using call" ): String {
                if( this && this.blah ) {
                    return arg + '\tthis=' + this + '\tblah=' + this.blah + '\targs=' + arguments + '\tname=' + getQualifiedClassName(arguments.callee);
                } else {
                    return arg + '\tthis=' + this + '\tblah=null\targs=' + arguments + '\tname=' + getQualifiedClassName(arguments.callee);
                }
            });
        }
        
        private function runTest( id: String, fnc: Function ): void {
            
            _tf.appendText( "\n\n\n" + id + " test: arguments=" + fnc.length + ", name=" + getQualifiedClassName(fnc) + ", proto=" + fnc.prototype);
            _tf.appendText( "\n  " + fnc.call( null ) );
            _tf.appendText( "\n  " + fnc.call( _test2 ) );
            _tf.appendText( "\n  " + fnc.call( this ) );
            _tf.appendText( "\n  " + fnc( "straigth" ) );
            _tf.appendText( "\n  " + fnc.apply( null, ["apply( null )"] ) );
            _tf.appendText( "\n  " + fnc.apply( _test2, ["apply( _test2 )"] ) );
            _tf.appendText( "\n  " + fnc.apply( this, ["apply( this )"] ) );
            _tf.appendText( "\n\n" + describeType( fnc ) );
        }

    }
}
import flash.utils.getQualifiedClassName;

class Test {
    public var blah: String;
    public var test: Function;
    
    function Test() {
        this.blah = "constructor";
        test = doIt;
    }
    
    public function doIt( arg: String = "using call" ): String {
        return arg + '\tthis=' + this + '\tblah='+ this.blah + '\targs=' + arguments + '\tname=' + getQualifiedClassName(arguments.callee);
    }
}
