/**
 * Copyright CheonSH ( http://wonderfl.net/user/CheonSH )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mMu9
 */

package {
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.display.Sprite;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.utils.ByteArray;
    import flash.media.SoundMixer;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.StageAlign;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.display.StageScaleMode;
    import flash.geom.Rectangle;
    import flash.filters.BlurFilter;    
    
    public class FlashTest extends Sprite {

        const num:int = 128;
        const sDis:Number = 30;
        const lDis:Number = 100;
        const maxDis:Number = 250;
        
        var i:int;
        var bgm:Sound = new Sound;
        var sc:SoundChannel;
        var power:Number;
        var aPower:Number;
        var ba:ByteArray = new ByteArray;
        var shape:Shape = new Shape();
        var bd:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
        var b:Bitmap = new Bitmap( bd );
        var center:Point = new Point;
        var rot:Number;
        var color:ColorTransform = new ColorTransform( 0.95, 1, 1, 0.9 );
        var blur:BlurFilter = new BlurFilter( 4, 4 );
        var numArr:Array = [];

        public function FlashTest() {
            // write as3 code here..
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            for( i = 0; i < num *2; ++ i )
            {
                numArr[ i ] = 0;
            }
            addChild( b );
            addChild( shape );
            
            Security.loadPolicyFile( 'http://www.shipnk.com/crossdomain.xml' );
            bgm.addEventListener( Event.COMPLETE, soundLoadedEvent );
            bgm.load( new URLRequest( 'http://www.shipnk.com/sound/LetMeHitIt.mp3' ) );
        }
        
        private function soundLoadedEvent ( e:Event ):void
        {
            sc = bgm.play( 0, 9999 );
            stage.addEventListener(Event.ENTER_FRAME, process );
            stage.addEventListener(Event.RESIZE, resizeEvent );
        }

        private function resizeEvent ( e:Event ) :void
        {
            b.bitmapData = bd = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
        }
        
        private function process ( e:Event ) :void
        {
            SoundMixer.computeSpectrum( ba, false );
            center.x = stage.stageWidth / 2;
            center.y = stage.stageHeight / 2;
            aPower = sc.leftPeak + sc.rightPeak;
            aPower /= 2;
            //
            shape.graphics.clear();
            shape.graphics.lineStyle( 1, 0xFF00FF );
            for( i = 0; i < num; ++ i )
            {
                power = ba.readFloat();
                power = Math.abs( power );
                numArr[ i ] += (power-numArr[ i ] ) * 0.25;
                power = numArr[ i ];
                rot = i * 360 / num * Math.PI / 180;
                shape.graphics.drawCircle( center.x + Math.sin( rot ) * (sDis+power*maxDis),
                                          center.y + Math.cos( rot ) * (sDis+power*maxDis),
                                          power * 20 );
            }
            //long
            shape.graphics.beginFill( 0xFF33FF, 1 );
            for( i = 0; i < num; ++ i )
            {
                power = ba.readFloat();
                power = Math.abs( power );
                numArr[ i ] += (power-numArr[ i ] ) * 0.25;
                power = numArr[ i ];
                rot = i * 360 / num * Math.PI / 180;
                shape.graphics.drawCircle( center.x + Math.sin( rot ) * (lDis+power*maxDis),
                                          center.y + Math.cos( rot ) * (lDis+power*maxDis),
                                          power * power * 10 );
            }
            bd.draw( shape );
            bd.fillRect( new Rectangle( 0,0, bd.width, 1 ), 0 );
            bd.fillRect( new Rectangle( 0,0, 1, bd.height ), 0 );
            bd.scroll( aPower * 3, aPower * 3 );
            bd.colorTransform( bd.rect, color );
            blur.blurX = sc.leftPeak * 10;
            blur.blurY = sc.rightPeak * 10;
            bd.applyFilter( bd, bd.rect, new Point, blur );
        }

    }
}