/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mMcg
 */

/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=60)]
	
	public class Main extends Sprite {
		
		private var emitter:BoxEmitter;
		
		public function Main():void {
			emitter = new BoxEmitter(new SteadyClock(0.2));
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
			renderer.addEmitter(emitter);
			
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
		
		private function mainLoop(e:Event):void {
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.easing.Elastic;
import idv.cjcat.stardust.common.initializers.CollisionRadius;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Collide;
import idv.cjcat.stardust.twoD.actions.Deflect;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Oriented;
import idv.cjcat.stardust.twoD.deflectors.BoundingBox;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.RectZone;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class BoxEmitter extends Emitter2D {
	
	public function BoxEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		addInitializer(new DisplayObjectClass(Box));
		addInitializer(new Life(new UniformRandom(150, 0)));
		addInitializer(new Position(new RectZone(0, 0, 465, 465)));
		addInitializer(new Velocity(new LazySectorZone(2, 1)));
		addInitializer(new Scale(new UniformRandom(1, 0.3)));
		addInitializer(new CollisionRadius(Box.HALF_SIZE));
		
		//actions
		var deflect:Deflect = new Deflect();
		deflect.addDeflector(new BoundingBox(0, 0, 465, 465));
		
		var scaleCurve:ScaleCurve = new ScaleCurve(50, 10);
		scaleCurve.inFunction = Elastic.easeOut;
		scaleCurve.inFunctionExtraParams = [1, 10];
		
		addAction(deflect);
		addAction(scaleCurve);
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new Move());
		addAction(new Collide());
		addAction(new Oriented());
	}
}

//------------------------------------------------------------------------------------------------

class Box extends Shape {
	
	public static const SIZE:Number = 30;
	public static const HALF_SIZE:Number = 0.5 * SIZE;
	
	public function Box() {
		graphics.beginFill(0x000000);
		graphics.drawRect( -HALF_SIZE, -HALF_SIZE, SIZE, SIZE);
	}
}