/**
 * Copyright bennett.yeates ( http://wonderfl.net/user/bennett.yeates )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mLVL
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Point;
    import flash.ui.Keyboard;

    [SWF(backgroundColor=0x0)]
    public class RayCastTest extends Sprite
    {
        private const FOV            :int = 60;
        private const STEP_LENGTH    :int = 5; //length of the ray to step by
        
        private var player            :Sprite;
        
        private var ray_drawer        :Sprite;
        private var squares           :Array = [];
        private const POSITIONS:Array = [ {x:0, y:0}, {x:0, y:stage.stageHeight/2}, {x:stage.stageWidth-100, y:stage.stageHeight/2 - 50}, 
                                          {x:stage.stageWidth/2, y:stage.stageHeight - 100}, {x:stage.stageWidth-100, y:stage.stageHeight - 100} ];
        public function RayCastTest()
        {
            ray_drawer = new Sprite();
            
            var i:int;
            for ( ; i < 5; ++i ) {
                var square:Sprite = new Sprite();
                square.graphics.beginFill(0);
                square.graphics.drawRect(0,0,100,100);
                
                square.x = POSITIONS[i].x;
                square.y = POSITIONS[i].y;
                
                addChild( square );    
                squares.push( square );
            }
            player = new Sprite();
            player.graphics.beginFill(0x0000FF);
            player.graphics.drawRect(0,0,5,5);
            
            player.x = stage.stageWidth/2 - 2.5;
            player.y = stage.stageHeight/2 - 2.5;
            addChild( player );
            addChild( ray_drawer );
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            addEventListener( Event.ENTER_FRAME, oef );
        }
        
        public function onKeyDown( e:KeyboardEvent ):void {
            if ( e.keyCode == Keyboard.LEFT ) { player.rotation -= 2; }
            else if ( e.keyCode == Keyboard.RIGHT ) { player.rotation += 2; }
        }
        
        public function oef( e:Event ):void {
            ray_drawer.graphics.clear();
            ray_drawer.graphics.lineStyle( 2, 0xFF0000 );
            
            var startRotation:Number = player.rotation - FOV/2;
            var endRotation:Number = player.rotation + FOV/2;
            
            var hit:Boolean;
            var length:int;
            while( startRotation < endRotation ) {
                hit = false;
                length = STEP_LENGTH;
                
                var pos:Point = new Point( player.x, player.y );
                while( !hit ) {
                    pos.x = player.x + length * Math.cos( startRotation * Math.PI / 180 );
                    pos.y = player.y + length * Math.sin( startRotation * Math.PI / 180 );
                    
                    var i:int;
                    for ( i=0; i < squares.length; ++i ) { 
                        var square:Sprite = squares[i];
                        if ( pos.x >= square.x && pos.y >= square.y ) {
                            if( pos.x <= square.x + 100 && pos.y <= square.y + 100 ) {
                                hit = true;
                            }
                        }
                        else if ( pos.x >= stage.stageWidth || pos.x < 0 || pos.y < 0 || pos.y >= stage.stageHeight ) {
                            hit = true;
                        }
                    }
                    length += STEP_LENGTH;
                }
                ray_drawer.graphics.moveTo( player.x, player.y );
                ray_drawer.graphics.lineTo( pos.x, pos.y );
                ++startRotation;
            }
        }
    }
}