/**
 * Copyright wonderwhyer ( http://wonderfl.net/user/wonderwhyer )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/mLRs
 */

// forked from rettuce's BeatFlower
package
{
    import caurina.transitions.Tweener;
    
    import com.bit101.components.ComboBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.PushButton;
    import com.demonsters.debugger.MonsterDebugger;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.ProgressEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.utils.ByteArray;    
    import com.codeazur.as3swf.SWF;
    import com.codeazur.as3swf.SWFData;
    import com.codeazur.as3swf.data.SWFScene;
    import com.codeazur.as3swf.data.SWFSymbol;
    import com.codeazur.as3swf.data.consts.SoundCompression;
    import com.codeazur.as3swf.data.consts.SoundRate;
    import com.codeazur.as3swf.data.consts.SoundSize;
    import com.codeazur.as3swf.data.consts.SoundType;
    import com.codeazur.as3swf.tags.TagDefineSceneAndFrameLabelData;
    import com.codeazur.as3swf.tags.TagDefineSound;
    import com.codeazur.as3swf.tags.TagDoABC;
    import com.codeazur.as3swf.tags.TagEnd;
    import com.codeazur.as3swf.tags.TagFileAttributes;
    import com.codeazur.as3swf.tags.TagSetBackgroundColor;
    import com.codeazur.as3swf.tags.TagShowFrame;
    import com.codeazur.as3swf.tags.TagSymbolClass;
    import flash.media.SoundChannel;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import flash.events.MouseEvent;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    /**
     * ...
     * @author rettuce
     * 
     * Sound パラメータあてこんでみた
     * 音はYoodaさんのKasanaを拝借。
     * http://soundcloud.com/yooda/kasana
     * 
     */
    
    [SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 40)]
    
    public class Main extends Sprite
    {
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();
            
      
            // SoundMixer
            playSoundMixer();


                        
            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
        }
        
        
        /* UI Setting */
        ///////////////////////////////////////////////////////////////////////
        
        private var _blmodeSelect:ComboBox;
        private var _slider1:HUISlider;
        private var _slider2:HUISlider;
        private var _slider3:HUISlider;
        private var _slider4:HUISlider;
        private var _slider5:HUISlider;
        private var _slider6:HUISlider;
        private var _loadBtn:PushButton;
        
        private function uiSet():void
        {
            var blArr:Array = [
                BlendMode.NORMAL,
                BlendMode.LAYER,
                BlendMode.OVERLAY,
                BlendMode.HARDLIGHT,
                BlendMode.DARKEN,
                BlendMode.DIFFERENCE
            ];
            _blmodeSelect = new ComboBox(this,10,10,'BlendMode',blArr);
            _blmodeSelect.selectedIndex = 3;
            
            _loadBtn = new PushButton(this, 120, 10, "Load MP3", up);
            
            _slider1 = new HUISlider(this, 340, 10, "Num");
            _slider2 = new HUISlider(this, 340, 25, "Length");
            _slider3 = new HUISlider(this, 340, 40, "Width ");
            _slider4 = new HUISlider(this, 340, 55, "Shape1");
            _slider5 = new HUISlider(this, 340, 70, "Shape2");
            _slider6 = new HUISlider(this, 340, 85, "Shape3");
            
            _slider1.width = _slider2.width = _slider3.width = _slider4.width = _slider5.width = _slider6.width = 150;
            
            _slider1.value = 50;
            _slider2.value = 50;
            _slider3.value = 50;
            _slider4.value = 50;
            _slider5.value = 50;
            _slider6.value = 50;
        }

                ///////////////////////////////////////////////////////////////////////
        
        public var fr:FileReference;
        public var soundSource:Sound;
        public var currentSong:SoundChannel;
        
        public function up(e:Event):void {
            fr = new FileReference();
            fr.addEventListener(Event.SELECT, onFileSelected);
            fr.addEventListener(Event.COMPLETE, parse);
            var mp3Filter:FileFilter = new FileFilter("mp3","*.mp3");
            fr.browse([mp3Filter]);
            if (currentSong)
            {
                currentSong.stop();
                currentSong = null;
            }
        }
        
        public function onFileSelected(e:Event):void
        {
            fr.load();
        }
        
        public function parse(e:Event):void
        {
            var swf:ByteArray = createSWFFromMP3(fr.data);
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, SoundLoaded);
            loader.loadBytes(swf);
        }
        
        public function SoundLoaded(e:Event):void
        {
            flowerInit();
            
            var SoundClass:Class = LoaderInfo(e.currentTarget).applicationDomain.getDefinition("MP3Wrapper_soundClass") as Class;

            soundSource = new SoundClass() as Sound;
            currentSong = soundSource.play();
            currentSong.addEventListener(Event.COMPLETE,songEnded);
        }
        
        public function songEnded(e:Event):void 
        {
            currentSong = null;            
        }

        
        public function createSWFFromMP3(mp3:ByteArray):ByteArray
        {
            // Create an empty SWF
            // Defaults to v10, 550x400px, 50fps, one frame (works fine for us)
            var swf:SWF = new SWF();

            // Add FileAttributes tag
            // Defaults: as3 true, all other flags false (works fine for us)
            swf.tags.push(new TagFileAttributes());

            // Add SetBackgroundColor tag
            // Default: white background (works fine for us)
            swf.tags.push(new TagSetBackgroundColor());

            // Add DefineSceneAndFrameLabelData tag 
            // (with the only entry being "Scene 1" at offset 0)
            var defineSceneAndFrameLabelData:TagDefineSceneAndFrameLabelData = new TagDefineSceneAndFrameLabelData();
            defineSceneAndFrameLabelData.scenes.push(new SWFScene(0, "Scene 1"));
            swf.tags.push(defineSceneAndFrameLabelData);

            // Add DefineSound tag
            // The ID is 1, all other parameters are automatically
            // determined from the mp3 itself.
            swf.tags.push(TagDefineSound.createWithMP3(1, mp3));

            // Add DoABC tag
            // Contains the AS3 byte code for the document class and the 
            // class definition for the embedded sound
            swf.tags.push(TagDoABC.create(abc));

            // Add SymbolClass tag
            // Specifies the document class and binds the sound class
            // definition to the embedded sound
            var symbolClass:TagSymbolClass = new TagSymbolClass();
            symbolClass.symbols.push(SWFSymbol.create(1, "MP3Wrapper_soundClass"));
            symbolClass.symbols.push(SWFSymbol.create(0, "MP3Wrapper"));
            swf.tags.push(symbolClass);

            // Add ShowFrame tag
            swf.tags.push(new TagShowFrame());

            // Add End tag
            swf.tags.push(new TagEnd());

            // Publish the SWF
            var swfData:SWFData = new SWFData();
            swf.publish(swfData);

            return swfData;
        }
        
        private static var abcData:Array = [
            0x10, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x19, 0x07, 0x6d, 0x78, 0x2e, 0x63, 0x6f, 0x72, 0x65, 
            0x0a, 0x49, 0x46, 0x6c, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x0a, 0x53, 0x6f, 0x75, 0x6e, 
            0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x0b, 0x66, 0x6c, 0x61, 0x73, 0x68, 0x2e, 0x6d, 0x65, 0x64, 
            0x69, 0x61, 0x05, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x6d, 0x78, 0x2e, 0x63, 0x6f, 0x72, 0x65, 
            0x3a, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x00, 0x15, 0x4d, 0x50, 0x33, 
            0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x61, 
            0x73, 0x73, 0x0a, 0x4d, 0x50, 0x33, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x0d, 0x66, 0x6c, 
            0x61, 0x73, 0x68, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x06, 0x53, 0x70, 0x72, 0x69, 
            0x74, 0x65, 0x0a, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x05, 0x43, 0x6c, 
            0x61, 0x73, 0x73, 0x2a, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x61, 
            0x64, 0x6f, 0x62, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x32, 0x30, 0x30, 0x36, 0x2f, 0x66, 0x6c, 
            0x65, 0x78, 0x2f, 0x6d, 0x78, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x07, 0x56, 
            0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x06, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x07, 0x33, 0x2e, 
            0x30, 0x2e, 0x30, 0x2e, 0x30, 0x0b, 0x6d, 0x78, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 
            0x6c, 0x06, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x0c, 0x66, 0x6c, 0x61, 0x73, 0x68, 0x2e, 0x65, 
            0x76, 0x65, 0x6e, 0x74, 0x73, 0x0f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x61, 
            0x74, 0x63, 0x68, 0x65, 0x72, 0x0d, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x62, 0x6a, 
            0x65, 0x63, 0x74, 0x11, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 
            0x62, 0x6a, 0x65, 0x63, 0x74, 0x16, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x62, 0x6a, 
            0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x0a, 0x16, 0x01, 0x16, 
            0x04, 0x18, 0x06, 0x16, 0x07, 0x18, 0x08, 0x16, 0x0a, 0x18, 0x09, 0x08, 0x0e, 0x16, 0x14, 0x03, 
            0x01, 0x01, 0x01, 0x04, 0x14, 0x07, 0x01, 0x02, 0x07, 0x01, 0x03, 0x07, 0x02, 0x05, 0x09, 0x02, 
            0x01, 0x07, 0x04, 0x08, 0x07, 0x04, 0x09, 0x07, 0x06, 0x0b, 0x07, 0x04, 0x0c, 0x07, 0x04, 0x0d, 
            0x07, 0x08, 0x0f, 0x07, 0x04, 0x10, 0x07, 0x01, 0x12, 0x09, 0x03, 0x01, 0x07, 0x04, 0x13, 0x07, 
            0x09, 0x15, 0x09, 0x08, 0x02, 0x07, 0x06, 0x16, 0x07, 0x06, 0x17, 0x07, 0x06, 0x18, 0x0d, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x05, 0x00, 0x02, 0x00, 0x02, 0x03, 0x09, 0x03, 0x01, 
            0x04, 0x05, 0x00, 0x05, 0x02, 0x09, 0x05, 0x00, 0x08, 0x00, 0x06, 0x07, 0x09, 0x07, 0x00, 0x0b, 
            0x01, 0x08, 0x00, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 0x01, 0x0a, 0x06, 0x01, 0x0b, 0x11, 0x01, 
            0x07, 0x00, 0x0a, 0x00, 0x05, 0x00, 0x01, 0x0c, 0x06, 0x00, 0x00, 0x08, 0x08, 0x03, 0x01, 0x01, 
            0x04, 0x00, 0x00, 0x06, 0x01, 0x02, 0x04, 0x00, 0x01, 0x09, 0x01, 0x05, 0x04, 0x00, 0x02, 0x0c, 
            0x01, 0x06, 0x04, 0x01, 0x03, 0x0c, 0x00, 0x01, 0x01, 0x01, 0x02, 0x03, 0xd0, 0x30, 0x47, 0x00, 
            0x00, 0x01, 0x00, 0x01, 0x03, 0x03, 0x01, 0x47, 0x00, 0x00, 0x03, 0x02, 0x01, 0x01, 0x02, 0x0a, 
            0xd0, 0x30, 0x5d, 0x04, 0x20, 0x58, 0x00, 0x68, 0x01, 0x47, 0x00, 0x00, 0x04, 0x02, 0x01, 0x05, 
            0x06, 0x09, 0xd0, 0x30, 0x5e, 0x0a, 0x2c, 0x11, 0x68, 0x0a, 0x47, 0x00, 0x00, 0x05, 0x01, 0x01, 
            0x06, 0x07, 0x06, 0xd0, 0x30, 0xd0, 0x49, 0x00, 0x47, 0x00, 0x00, 0x06, 0x02, 0x01, 0x01, 0x05, 
            0x17, 0xd0, 0x30, 0x5d, 0x0d, 0x60, 0x0e, 0x30, 0x60, 0x0f, 0x30, 0x60, 0x03, 0x30, 0x60, 0x03, 
            0x58, 0x01, 0x1d, 0x1d, 0x1d, 0x68, 0x02, 0x47, 0x00, 0x00, 0x07, 0x01, 0x01, 0x06, 0x07, 0x03, 
            0xd0, 0x30, 0x47, 0x00, 0x00, 0x08, 0x01, 0x01, 0x07, 0x08, 0x06, 0xd0, 0x30, 0xd0, 0x49, 0x00, 
            0x47, 0x00, 0x00, 0x09, 0x02, 0x01, 0x01, 0x06, 0x1b, 0xd0, 0x30, 0x5d, 0x10, 0x60, 0x0e, 0x30, 
            0x60, 0x0f, 0x30, 0x60, 0x03, 0x30, 0x60, 0x02, 0x30, 0x60, 0x02, 0x58, 0x02, 0x1d, 0x1d, 0x1d, 
            0x1d, 0x68, 0x05, 0x47, 0x00, 0x00, 0x0a, 0x01, 0x01, 0x08, 0x09, 0x03, 0xd0, 0x30, 0x47, 0x00, 
            0x00, 0x0b, 0x02, 0x01, 0x09, 0x0a, 0x0b, 0xd0, 0x30, 0xd0, 0x60, 0x05, 0x68, 0x08, 0xd0, 0x49, 
            0x00, 0x47, 0x00, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x08, 0x23, 0xd0, 0x30, 0x65, 0x00, 0x60, 0x0e, 
            0x30, 0x60, 0x0f, 0x30, 0x60, 0x11, 0x30, 0x60, 0x12, 0x30, 0x60, 0x13, 0x30, 0x60, 0x07, 0x30, 
            0x60, 0x07, 0x58, 0x03, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x68, 0x06, 0x47, 0x00, 0x00
        ];

        private static function abcDataToByteArray():ByteArray {
            var ba:ByteArray = new ByteArray();
            for (var i:uint = 0; i < abcData.length; i++) {
                ba.writeByte(abcData[i]);
            }
            return ba;
        }
        
        private static var abc:ByteArray = abcDataToByteArray(); 
        
        
        
        /* Sound Mixer */
        ///////////////////////////////////////////////////////////////////////
        
        private var _bArr:ByteArray = new ByteArray();
        private var _bg:Bitmap;
        private var _num:Object = new Object();
        
        private function playSoundMixer():void
        {            
            _bg = new Bitmap();
            _bg.smoothing = true;
            _bg.bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight );
            addChild(_bg);
            
            uiSet();
            addEventListener(Event.ENTER_FRAME,beatCheck2);

        }
        
        private function beatCheck2(e:Event):void
        {
            SoundMixer.computeSpectrum(_bArr, false, 0);    //　byteArr(length=512), FFT, rate 0->44.1 KHz, 1->22.05KHz...
            _bArr.position = 0;
            
            var byteTotal:Number = 0;    // 両音
            var byte:Number      = 0;
            
            for(var i:int = 0; i < 512; i++)
            {
                byte = Math.abs(_bArr.readFloat());
                byteTotal += byte;
            };
            
            byteTotal /= 512;            
            if(byteTotal>0.01){
                Tweener.addTween( _num, { x:byteTotal, time:0.4, transition:'easeOutQuad' });
            }
            
//            _bg.bitmapData.draw( stage, new Matrix(3,0,0,3,-stage.stageWidth,-stage.stageHeight), null, _blmodeSelect.selectedItem.toString() );
            _bg.bitmapData.draw( stage, new Matrix(2,0,0,2,-stage.stageWidth/2,-stage.stageHeight/2), null, _blmodeSelect.selectedItem.toString());
            
            var num:int = Math.round(_num.x*(_slider1.value))+6;
            _flower.NUM = num;
            _flower.W   = _num.x*(25*(_slider2.value)*0.5+500);
            _flower.H   = (180*(_slider3.value)*0.01)/num + _num.x*100;
            _flower.FY  = _num.x*(0.1*(_slider4.value)+1);
            _flower.FT  = _num.x*(0.08*(_slider5.value)+2);
            _flower.K   = _num.x*(8*(_slider6.value));
            _flower.Z   = _num.x*10;
            _flower.drawFlower();
        }
        
        
        
        /* Flower Setting */
        /////////////////////////////////////////////////////////////////////////　        
        private var _flower:Flower;
        private var _s:Flower;
        
        private function flowerInit():void
        {
            if(_flower)
            {
                removeChild(_flower);
            }

            _flower = new Flower();
//            _flower._fillFlg = false;
            addChildAt(_flower,1);
            
            _flower.x = stage.stageWidth/2;
            _flower.y = stage.stageHeight/2;
        }        
        
        
        
        
        /* Error Handler */
        //////////////////////////////////////////////////////////////////
        
        private function errorHandler(e:IOErrorEvent):void
        {
            MonsterDebugger.trace( 'Error...', e );
        }
        
        
        /* stage set */
        //////////////////////////////////////////////////////////////////
        
        private function setStage():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void
        {
            resizeHandler();
        }        
        public function resizeHandler():void
        {
            
        }

    }
}


import flash.display.GradientType;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Point;

class Flower extends Sprite
{
    private var _g:Graphics;
    
    private var _NUM:uint = 10;            // 枚数
    private var _W:uint = 180;            //幅
    private var _H:uint = 30;            //高さ
    private var _FY:Number = 0.7;        //膨らみ位置 横
    private var _FT:Number = 0.5;        //膨らみ位置 縦
    private var _K:uint    = 20;        //深さ
    private var _Z:Number  = 5;            //ズレ
    private var _zure:Array = [];
    
    public var _fillFlg:Boolean = true;
    
    public function Flower()
    {
        _g = this.graphics;
        
        for (var i:int = 0; i < 7; i++) { _zure[i] = new Point();}
        drawFlower();
    }
    
    public function drawFlower($num:Number=0):void
    {            
        // Line&Color Setting
        if(!_fillFlg){
            _g.clear();
            _g.lineStyle( 0.5, 0 );
            _g.beginFill(0xFFFFFF);
        }else{
            _g.clear();
            //                _g.lineStyle( 1, 0xca4000 );
            var fillType:String = GradientType.RADIAL;
            
            
            var colors:Array;
            var dropColor:Number;
            
            switch($num){
                case 0:
                    colors    = [0xca4000, 0xde878b, 0xffaec1, 0xffd4ef];
                    //                        colors    = [0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF];
                    dropColor = 0xca4000;
                    break;
                
                case 1:
                    colors    = [0xca4000, 0xde878b, 0xffaec1, 0xffd4ef];
                    dropColor = 0xca4000;
                    break;
                
                case 2:
                    colors    = [0x0040cd, 0x5990ff, 0x90c9ff, 0xd7ebff];
                    dropColor = 0x5990ff;
                    break;
                
                case 3:
                    colors    = [0xffd4ef, 0xffaec1, 0xde878b, 0xca4000 ];
                    dropColor = 0xffd4ef;                        
                    break;
            };
            
            
            var alphas:Array = [1, 1, 1, 1];
            //                var alphas:Array = [1 , Math.random()+0.3, Math.random()+0.3, 1];
            var ratios:Array = [0, 80, 180, 255];
            
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(-_W*2, -_W*2, 0, _W, _W );
            _g.beginGradientFill(fillType, colors, alphas, ratios, matrix);                
        }
        
        
        // draw Petal
        for(var i:int=0; i < _NUM; i++){
            var ang:Number = ( 2*Math.PI/_NUM*i - Math.PI/2 );
            drawPetal(ang);
        }
        
        // DropShadow
        var filArr:Array = new Array();
        var dsFilter:DropShadowFilter = new DropShadowFilter( 0, 10, dropColor, 0.7, 15, 15, 3);
        filArr.push(dsFilter);
        filters = filArr;
    }
    
    private function drawPetal(ang:Number):void
    {
        
        for (var u:int = 0; u < 7; u++) {
            _zure[u].x = Math.random()*_Z-_Z/2;
            _zure[u].y = Math.random()*_Z-_Z/2;
        }
        
        var pointArr:Array = [];
        var px:Number;
        var py:Number
        
        var x1:Number = _W*_FY/2;
        var x2:Number = _W*_FY;
        var x3:Number = _W;
        var x4:Number = _W-_K;
        var y1:Number = _H*_FT;
        var y2:Number = _H;
        var y3:Number = _H*_FT/2;
        var y4:Number = 0;
        
        var leng1:Number = Math.sqrt( x1*x1 + y1*y1 );
        var leng2:Number = Math.sqrt( x2*x2 + y2*y2 );
        var leng3:Number = Math.sqrt( x3*x3 + y3*y3 );
        var leng4:Number = Math.sqrt( x4*x4 + y4*y4 );
        
        var ang1:Number = y1/leng1;
        var ang2:Number = y2/leng2;
        var ang3:Number = y3/leng3;
        var ang4:Number = y4/leng4;
        
        pointArr.push(new Point(0, 0));
        pointArr.push( new Point( Math.cos(ang-ang1)*leng1+_zure[0].x , Math.sin(ang-ang1)*leng1+_zure[0].y ));
        pointArr.push( new Point( Math.cos(ang-ang2)*leng2+_zure[1].x , Math.sin(ang-ang2)*leng2+_zure[1].y ));
        pointArr.push( new Point( Math.cos(ang-ang3)*leng3+_zure[2].x , Math.sin(ang-ang3)*leng3+_zure[2].y ));            
        
        _g.moveTo(pointArr[0].x, pointArr[0].y);
        for(var i:int=0; i<pointArr.length-1; i++){
            px = (pointArr[i+1].x + pointArr[i].x)/2;
            py = (pointArr[i+1].y + pointArr[i].y)/2;                
            _g.curveTo(pointArr[i].x, pointArr[i].y, px, py);
        }
        _g.lineTo(pointArr[pointArr.length-1].x+_zure[3].x , pointArr[pointArr.length-1].y+_zure[3].y );
        
        _g.lineTo( Math.cos(ang+ang4)*leng4, Math.sin(ang+ang4)*leng4 );
        _g.lineTo( Math.cos(ang+ang3)*leng3+_zure[4].x  , Math.sin(ang+ang3)*leng3+_zure[4].y  );
        
        pointArr = [];
        pointArr.push( new Point( Math.cos(ang+ang3)*leng3+_zure[4].x , Math.sin(ang+ang3)*leng3+_zure[4].y ));            
        pointArr.push( new Point( Math.cos(ang+ang2)*leng2+_zure[5].x , Math.sin(ang+ang2)*leng2+_zure[5].y ));
        pointArr.push( new Point( Math.cos(ang+ang1)*leng1+_zure[6].x , Math.sin(ang+ang1)*leng1+_zure[6].y ));
        pointArr.push(new Point(0, 0));
        
        for(i=0; i<pointArr.length-1; i++){
            px = (pointArr[i+1].x + pointArr[i].x)/2;
            py = (pointArr[i+1].y + pointArr[i].y)/2;                
            _g.curveTo(pointArr[i].x, pointArr[i].y, px, py);
        }
        _g.lineTo(pointArr[pointArr.length-1].x, pointArr[pointArr.length-1].y );
    }
    
    private function angleMath($x:Number, $y:Number):Number
    {
        var dx:Number = $x - $x;
        var dy:Number = $y - 0;
        return Math.atan2(dy , dx)*180/Math.PI;
    }
    
    
    
    
    
    /* Setter & Getter */
    /////////////////////////////////////////////////////////////////////////
    
    public function set NUM($NUM:uint):void{ _NUM = $NUM; }
    public function set W  ($W:uint):void  { _W   = $W;   }
    public function set H  ($H:uint):void  { _H   = $H;   }
    public function set FY ($FY:Number):void{ _FY = $FY;  }
    public function set FT ($FT:Number):void{ _FT = $FT;  }
    public function set K  ($K:uint):void  { _K   = $K;   }
    public function set Z  ($Z:uint):void  { _Z   = $Z;   }
}




