/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mKv9
 */

package
{    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(new CustomContainer());
            
            init();
        }
        
        public function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0);
            graphics.drawRect(0, 0, 464, 464);    
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class CustomContainer extends Sprite
{
    protected var _x:Number;
    protected var _y:Number;
    protected var _width:Number;
    protected var _height:Number;
    protected var _alpha:Number;
    protected var _color:Number;
    
    private var textOutput:Output;
    private var columnCount:int;
    private var scrollMargin:int;
    private var scrollHeight:int;
    private var lineThickness:int; 
    private var columnThickness:int;
    private var columnContainer:Sprite;
    
    private var mousePrev:Point = new Point();
    private var mouseCurrent:Point = new Point();
    private var mouseCalc:Point = new Point();
    
    public function CustomContainer($x:Number = 0, $y:Number = 0, $width:Number = 465, $height:Number = 465, $columns:int = 3)
    {
        textOutput = new Output("CustomContainer");
        columnCount = $columns;
        scrollMargin = 5;
        scrollHeight = 1000;
        lineThickness = 6;
        columnThickness = 1;
        columnContainer = new Sprite();
        
        var x_:Number = $x;
        var y_:Number = $y;
        var width_:Number = $width;
        var height_:Number = $height;
        var alpha_:Number = 0.25;
        var color_:Number = 0;
        
        _x = x_;
        _y = y_;
        _width = width_;
        _height = height_;
        _alpha = alpha_;
        _color = color_;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(columnContainer);
        addChild(textOutput);
        
        init();
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function init() :void
    {
        columnContainer.graphics.clear();
        columnContainer.graphics.beginFill(_color, (_alpha / 2));
        columnContainer.graphics.drawRect(0, _height - scrollHeight, _width, scrollHeight);
        
        graphics.clear();
        graphics.lineStyle(lineThickness, _color, _alpha);
        graphics.moveTo(_width - scrollMargin, scrollHeight - _height + 10);
        graphics.lineTo(_width - scrollMargin, scrollHeight - _height + (465 / scrollHeight) * 465);
        graphics.lineStyle(1, _color, _alpha);
        for (var $:int = 2; $ < ((scrollHeight / scrollMargin) - 0.5); $++)
        {
            graphics.moveTo(_width - (scrollMargin / 2), (scrollMargin * $));
            graphics.lineTo(_width - scrollMargin - (scrollMargin / 2), (scrollMargin * $) - scrollMargin);
        }
    }
    
    public function onMouseDown($e:*) :void
    {
        removeEventListener(Event.ENTER_FRAME, onFrame);
        
        mousePrev = new Point($e.stageX, $e.stageY);
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public function onMouseMove($e:*) :void
    {
        mouseCurrent = new Point($e.stageX, $e.stageY);
        mouseCalc = mouseCurrent.subtract(mousePrev);
        
        height = (height + mouseCalc.y);
        
        mousePrev = mouseCurrent;
    }
    
    public function onMouseUp($e:*) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        addEventListener(Event.ENTER_FRAME, onFrame);
    }
    
    public function onFrame($e:*) :void
    {
        if (_height > scrollHeight + 4)
        {
            height-=int((height - scrollHeight) / 4);
        }
        if (_height < 465)
        {
            height+=int((465 - height) / 4);
        }
        else
        {
            //height = scrollHeight;    
            
            //removeEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        textOutput.content = "Height: " + _height + "\nScrollHeight: " + scrollHeight;
    }

    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get width() :Number
    { return _width }
    public override function get height() :Number
    { return _height }
    public override function get alpha() :Number
    { return _alpha }
    public function get color() :Number
    { return _color }
    
    public override function set x($:Number) :void
    { _x = $; init() }
    public override function set y($:Number) :void
    { _y = $; init() }
    public override function set width($:Number) :void
    { _width = $; init() }
    public override function set height($:Number) :void
    { _height = $; init() }
    public override function set alpha($:Number) :void
    { _alpha = $; init() }
    public function set color($:Number) :void
    { _color = $; init() }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
}