/**
 * Copyright GARENA123 ( http://wonderfl.net/user/GARENA123 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mKir
 */

//製作中





package {
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.primitives.Plane;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    [SWF(width = 465, height = 465, frameRate = 40 ,backgroundColor="#00001A")]
    public class Main extends Sprite {
		private static var STAGE_W:uint = 465;
		private static var STAGE_H:uint = 465;
		
		//ゲームの管理
		private var gameState:String = "title";//"game","gameover"
		private var gameWaitFrame:int = 0;
		private var gameScore:int = 0;
		private var gameMeter:int = 0;
		private var gameSp:int = 0;
		private var gameRingFrame:int = 0;
		private var ringAddR:Number = 0;
		private var ringAddRSp:Number = 0.05;
		private var ringPoint:Point = new Point(0, 0);
		
		//3D
        private var container:ConflictContainer
        private var camera:Camera3D
        private var controller:SimpleObjectController
        private var boxs:Array;
        //
        private var cameraR:Number = 0;
        private var cameraRSpX:Number = 0.005;
        private var cameraRSpY:Number = 0.01;
        //
        private var mat0:FillMaterial;
        private var mat1:FillMaterial;
        private var mat2:FillMaterial;
        private var mat3:FillMaterial;
        private var mat4:FillMaterial;
        private var mat5:FillMaterial;
        
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        private var bmdFade:BitmapData;
        
        private var layer3D:Sprite;
        private var layerBmp:Sprite;
        
        public function Main():void {
            layer3D = new Sprite();
            layerBmp = new Sprite();
            
            container = new ConflictContainer();
            camera = new Camera3D();
            camera.y = -500;
			camera.farClipping = 4000;
            container.addChild(camera);
            
            boxs = [];
            
            mat0 = new FillMaterial(0x1119CC, 1, 1, 0x0033CC);
            mat1 = new FillMaterial(0x1119AD, 1, 1, 0x0033CC);
            mat2 = new FillMaterial(0x11198F, 1, 1, 0x0033CC);
            mat3 = new FillMaterial(0x111970, 1, 1, 0x0033CC);
            mat4 = new FillMaterial(0x111952, 1, 1, 0x0033CC);
            mat5 = new FillMaterial(0x111933, 1, 1, 0x0033CC);
            //SimpleObjectControllerを使って、ターゲットにしたオブジェクトの座標をカーソルキーとマウスで操作でるようにする
            //controller = new SimpleObjectController(stage, camera, 500);
            //controller.lookAtXYZ(0, 0, 0);
            camera.view = new View(465, 465, true);
			camera.rotationX = Math.PI * -0.5
            layer3D.addChild(camera.view);
            
            bmd = new BitmapData(465, 465, false, 0x000000);
            bmdFade = new BitmapData(465, 465, true, 0x11000000);
            bmp = new Bitmap(bmd);
            layerBmp.addChild(bmp);
            
            //addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            addChild(layer3D);
            addChild(layerBmp);
            
        }
		//シーンの初期化、消去
		private function titleInit():void {
		
		}
		private function titleRemove():void {
		
		}
		private function gameInit():void {
		
		}
		private function gameRemove():void {
		
		}
		private function endingInit():void {
		
		}
		private function endingRemove():void {
		
		}
		//
		//Boxのリングを作成
		private function addRing() {
			var myTotal:uint = 10;
			var mySize:uint = 100;
			var myDefR:Number = Math.PI * Math.random();
			ringAddR += ringAddRSp;
			ringPoint.x = Math.random() * 200 - 100;
			ringPoint.y = Math.random() * 200 - 100;
			for (var i:int = 0; i < myTotal; i++) {
				var myBox:Box = new Box(40, 100, 10, 1, 1, 1, false, false, mat0, mat1, mat2, mat3, mat4, mat5);
				var myR:Number = (Math.PI * 2 / myTotal) * i + ringAddR;
				myBox.x = Math.sin(myR) * mySize + ringPoint.x;
				myBox.y = 2000;
				myBox.z = Math.cos(myR) * mySize + ringPoint.y;
				//myBox.rotationX = Math.random() * Math.PI;
				myBox.rotationY = myR
				//myBox.rotationZ = Math.random() * Math.PI;
				boxs.push(myBox)
				container.addChild(myBox);
			}
			
		}
		
        //ボックスを作成
        private function addBox():void {
            var myBox:Box = new Box(Math.random() * 80 + 30, Math.random() * 400 + 100, Math.random() * 30 + 10, 1, 1, 1, false, false, mat0, mat1, mat2, mat3, mat4, mat5);
            var myR:Number = Math.random() * Math.PI * 2
            var myPos:Number = Math.random() * 500 + 50;
            myBox.x = Math.sin(myR) * myPos;
            myBox.y = 4000;
            myBox.z = Math.cos(myR) * myPos;
            //myBox.rotationX = Math.random() * Math.PI;
            myBox.rotationY = myR
            //myBox.rotationZ = Math.random() * Math.PI;
            boxs.push(myBox)
            container.addChild(myBox);
        }
        //毎フレーム実行
        private function onEnterFrame(e:Event):void {
            //addBox();
            //addBox();
			gameWaitFrame++;
			if(gameWaitFrame >= 20){
				addRing();
				gameWaitFrame = 0;
			}
            var myLength:int = boxs.length;
            for (var i:int = myLength - 1; i >= 0; i--) {
                var myBox:Box = boxs[i];
                myBox.y -= 20;
                if (myBox.y < -800) {
                    container.removeChild(myBox);
                    boxs[i] = null;
                    boxs.splice(i, 1);
                }
            }
			/*
            cameraR += cameraRSpX;
            camera.rotationX = Math.PI * -0.35
            camera.rotationZ = Math.cos(cameraR);
            camera.rotationY += cameraRSpY;
			*/
            //controller.update();
            camera.render();
			//
			camera.x += (mouseX - STAGE_W * 0.5) * 0.03;
			camera.z += ( -(mouseY - STAGE_H * 0.5)) * 0.03;
			camera.rotationZ = -(mouseX - STAGE_W * 0.5) * 0.003;
            camera.rotationX = ( -(mouseY - STAGE_H * 0.5)) * 0.003 + Math.PI * -0.5
			//
            bmd.draw(bmdFade);
            
            bmd.draw(layer3D, null, null, "add");
			bmd.applyFilter(bmd, bmd.rect, new Point(), new BlurFilter(4, 4, 1));
            bmd.draw(layer3D, null, null, "add");
            //bmd.draw(bmd, null, null, "add");
            
        }

    }
}