/**
 * Copyright oreore ( http://wonderfl.net/user/oreore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mKPw
 */

package  
{
	
	//flash
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	//papervision3D
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.view.BasicView;
	
	//プロファイラー
	import com.flashdynamix.utils.SWFProfiler;

	
	public class Main extends Sprite
	{
		private var plane:Plane;
		private var viewPort:BasicView;
		
		public function Main() 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			SWFProfiler.init(this);
			init();
		}
		
		private function init():void
		{
			
			/************************************************************************
			* 1 ビューポートを作成（BasicViewを使う）
			************************************************************************/
			viewPort = new BasicView(stage.stageWidth, stage.stageHeight, true, false);
			viewPort.buttonMode = true;
			addChild(viewPort);
			
			/************************************************************************
			* 2.カメラの設定
			* BasicView を new したときに　カメラが生成されているので
			* viewPort.camera　でアクセスします。
			************************************************************************/
			viewPort.camera.z = -1000;
			viewPort.camera.y = 500;
			
			/************************************************************************
			* 3.シーンの作成
			* カメラと同様にBasicView を new したときに　シーンも生成され
			* ているので今回はnew しない。
			************************************************************************/
			//今回は特になにもしないが混乱を避けるためにあえて記載しとく
			//なしもしないけどシーンはできてるよ～！
			//空のDisylayObject3Dをworldとして作成すると便利かも？
			
			/************************************************************************
			* 4.レンダリング
			* こちらも同様にBasicViewをnew したときにBasicRenderEngine
			* が生成されてますので、アクセスはviewPort.startRendering()
			************************************************************************/
			viewPort.startRendering();
			
			/************************************************************************
			*　5.3Dオブジェクトの生成
			************************************************************************/
			
			//板を作成
			var wfm:WireframeMaterial = new WireframeMaterial();
			wfm.doubleSided = true;//裏も描画する
			plane = new Plane(wfm, 300, 200, 4, 4);
			viewPort.scene.addChild(plane);
			
			//床を作成
			var floorMate:CompositeMaterial = new CompositeMaterial();
			floorMate.addMaterial(new WireframeMaterial(0x696969,50));
			floorMate.addMaterial(new ColorMaterial(0xdcdcdc,0.5));
			var floor:Plane = new Plane(floorMate, 1000, 1000, 12, 12);
			floor.rotationX = 90;
			viewPort.scene.addChild(floor);
			
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
		}
		
		private function onEnterFrame(e:Event):void 
		{
			plane.y += 1;
			plane.rotationX += 1;
			plane.rotationZ += 1;
			
		}
		
	}
	
}