/**
 * Copyright genny ( http://wonderfl.net/user/genny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mJaM
 */

package
{
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;

	public class Main extends Sprite
	{
		
		/**
		*	property
		*/
		var base:Sprite;
		var pos:Array;
		var en:Array;
		var timer:Timer;
		const HANKEI:int = 60;
		const HANKEIY:int = 120;
		
		/**
		*	constructer
		*/
		function Main()
		{
			//	baseの生成
			base = new Sprite();
			base.graphics.clear();
			base.graphics.beginFill( 0XFFFFFF );
			base.graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight);
			base.graphics.endFill();
			base.x = stage.stageWidth/2;
			base.y = stage.stageHeight/2;
			addChild( base );
			
			//	円の生成
			pos = new Array();
			en = new Array();
			for( var i:int = 0; i < 300; i ++ )
			{
				
				var sp:Sprite = new Sprite();
				sp.graphics.clear();
				sp.graphics.beginFill( Math.random() * 0xFFFFFF );
				sp.graphics.drawCircle( 0, 0, 5);
				sp.graphics.endFill();
				
				var blur:BlurFilter = new BlurFilter( i/100, i/100, 3);
				sp.filters = [blur];
				
				var kakudo:Number = i * Math.PI * 2.0 * ( ( 1 + Math.sqrt(5)) / 2);
				
				var theX:Number = (i + 15) * Math.cos( kakudo );
				var theY:Number = (i + 15) * Math.sin( kakudo );
				
				pos.push( new Point( theX, theY ) );
				en.push( sp );
				
				sp.x = 0;
				sp.y = 0;
				
				base.addChild( sp );
				
			}
			
			
			timer = new Timer( 33 );
			timer.addEventListener( TimerEvent.TIMER, loop );
			timer.start();

			
		}
		
		
		function loop( event:TimerEvent ) :void
		{
			
			for( var i:int = 0; i < en.length; i ++ )
			{
				en[ i ].x += ( pos[ i ].x - en[ i ].x ) / 10;
				en[ i ].y += ( pos[ i ].y - en[ i ].y ) / 10;
			}
			
		}
		

	}

	
}