/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mJOV
 */

// forked from mousepancyo's frocessing with SoundMixer
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.utils.Timer;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    
    public class Main extends Sprite {
        private const WIDTH:Number  = 465;
        private const HEIGHT:Number = 465;
        private const SOUNDPATH:String = "http://kouetu.sakura.ne.jp/mp3_mujic/Christmas_Song.mp3"
        
        private var _canvas:Canvas;
        private var _bmd:BitmapData;
        private var _bm:Bitmap;
        private var _saveBmd:BitmapData;
        private var _container:Sprite = new Sprite();
        private var _ctf:ColorTransform = new ColorTransform(0.7, 0.7, 0.7, 0.5);
        private var _timer:Timer
        
        public function Main(){
            addChild(_container);
            _canvas = new Canvas(WIDTH, HEIGHT, SOUNDPATH);
            _bmd = new BitmapData(WIDTH, HEIGHT, true, 0);
            _container.addChild(_canvas);
            _container.addChild(_bm = new Bitmap(_bmd) as Bitmap);
            _bm.blendMode = "add";
            //
            addEventListener(Event.ENTER_FRAME, update);
            _timer = new Timer(600);
            _timer.addEventListener(TimerEvent.TIMER, removedInterval);
            _timer.start();
        }
        
        private function update(e:Event):void{
            _bmd.draw(_canvas, null, _ctf, "add");
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(), new BlurFilter(8, 8, 3));
        }
        
        private function removedInterval(e:TimerEvent):void{
            _canvas.remove();
        }
    }
}


import frocessing.display.*;
import flash.geom.Point;
import flash.utils.ByteArray;
import flash.media.SoundMixer;
  
class Canvas extends F5MovieClip2DBmp{ 
    private var _w:Number;
    private var _h:Number;
    private var _t:Number = 0;
    private var _pastPos:Point;
    private var _px:Number = 0;
    private var _py:Number = 0;
    private var _r:Number = 0;
    private var _list:Array = new Array();
    private var _soundPath:String;
    private var _waveBytes:ByteArray = new ByteArray();
    private var _sound:SoundPlayStop;
    
    public function Canvas($w:Number, $h:Number, $soundPath:String) {
        _w = $w;
        _h = $h;
        _soundPath = $soundPath;
        super();
    }
    
    public function setup():void {
        for(var i:uint=0; i<5; i++){
            var p:Point = new Point(random(0 ,_w), random(0 ,_h));
            _list.push(p);
        }
        size(_w, _h);
        background(0);
        noFill();
        colorMode(HSV, 2, 1, 1);
        //
        _sound=new SoundPlayStop();
        _sound.soundStart(_soundPath, 100);
    }

    public function draw():void{
        var n:int;
        try{
            SoundMixer.computeSpectrum(_waveBytes, true, 0);
            n = _waveBytes.readFloat() * 250;
        }catch(e:Error){
            return;
        }
        //
        var rad:Number = _r * .3 * Math.PI / 180;
        var px:Number = _w * .5 + Math.cos(rad) * n;
        var py:Number = _h * .5 + Math.sin(rad) * n;
        //
        var p:Point;
        p = new Point(px, py);
        //
        if(p && _pastPos){
            var distance:int = Point.distance(p, _pastPos);
            _pastPos = p;
            //
            var r:int = Math.random() * 8
            for(var i:int; i<distance * .3 ;i++){
                stroke(_t, 0.8, 1, 0.1);
                _px += (p.x + (Math.random() * distance-distance / 4) - _px) * Math.random() * 0.5;    
                _py += (p.y + (Math.random() * distance-distance / 4) - _py) * Math.random() * 0.5;
                ellipse(_px, _py, r * distance / 4, r * distance / 4);
            }
            _pastPos = p;
        }else{
            _pastPos = new Point(px, py);
        }
        _t += 0.1;
        _r += 30;
    }
    
    public function remove():void{
        background(0, 1);
        _t = 0;
    }
}


//Sound
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.media.SoundLoaderContext;
import flash.net.URLRequest;
import flash.system.Security;

class SoundPlayStop extends EventDispatcher{
        
    public var my_sc:SoundChannel;
    public var my_sound:Sound;                
    public var _flg:Boolean = true;
    
    public function SoundPlayStop(){
        Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
    }

    public function soundStart(Url:String, ref:uint = 1, vol:Number = 1):void {
        if(_flg){
            var trans:SoundTransform = new SoundTransform(vol,0);
            var context:SoundLoaderContext = new SoundLoaderContext(); 
            context.checkPolicyFile = true;
            //
            if (my_sc != null) {
                my_sc.stop();
                my_sc = null;
            }
            try{
                my_sound = new Sound(new URLRequest(Url),context);
                my_sc = my_sound.play(0,ref);
                my_sc.soundTransform = trans;
            }catch(e:Error){
                trace(e,Url);
            }
        }
    }

    public function soundStop():void {
        if (my_sc != null) {
            my_sc.stop();
            my_sc = null;
            my_sound = null;
        }
    }
}