/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mJJ0
 */

// forked from ProjectNya's スムージング
////////////////////////////////////////////////////////////////////////////////
// スムージング
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.geom.Rectangle;

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
     import flash.display.StageQuality;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "3/30/3017/3017fcecb780512f5c2b28596dbf9d0b43bd2f87";
        private static var scale:Number = 0.5;
        private static var CR:String = String.fromCharCode(13);

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
        }
        private function complete(evt:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, complete);
            //
            var bitmap:Bitmap = Bitmap(loader.content);
            addChild(bitmap);
            bitmap.x = 72;
            bitmap.y = 22;
            //
            var matrix:Matrix = new Matrix();
            matrix.scale(scale, scale);
            //
            var bitmapData1:BitmapData = new BitmapData(bitmap.width*scale, bitmap.height*scale, false, 0xFF000000);
            bitmapData1.draw(bitmap.bitmapData, matrix, null, null, null, false);
            var bitmap1:Bitmap = new Bitmap(bitmapData1);
            bitmap1.smoothing = true;
            addChild(bitmap1);
            bitmap1.x = 42;
            bitmap1.y = 282;
            var label1:Label = new Label(200, 20);
            addChild(label1);
            label1.textColor = 0x666666;
            label1.text = "BitmapData.draw(): false" + CR + "Bitmap.smoothing: false";
            label1.x = 42;
            label1.y = 402;
            //
            var bitmapData2:BitmapData = new BitmapData(bitmap.width*scale, bitmap.height*scale, false, 0xFF000000);
            drawTest(bitmap.bitmapData, bitmapData2);
            //bitmapData2.draw(bitmap.bitmapData, matrix, null, null, null, true);
            var bitmap2:Bitmap = new Bitmap(bitmapData2);
            bitmap2.smoothing = true;
            addChild(bitmap2);
            bitmap2.x = 262;
            bitmap2.y = 282;
            var label2:Label = new Label(200, 20);
            addChild(label2);
            label2.textColor = 0x666666;
            label2.text = "BitmapData.draw(): true" + CR + "Bitmap.smoothing: true";
            label2.x = 262;
            label2.y = 402;
        }
        
        private function drawTest(base: BitmapData, target: BitmapData): void 
        {
            var r: Rectangle = base.rect;
            if (r.width  % 2) r.width  -= 1;
            if (r.height % 2) r.height -= 1;
            var vec: Vector.<uint> = base.getVector(r);
            vec.fixed = true;
            var i: uint, n: uint = vec.length >> 2, res: Vector.<uint> = new Vector.<uint>(n, true), w: int = r.width;
            for (; i < n; i++) 
            {
                var u: uint = i << 1;
                var ux: uint = u % w;
                var uy: uint = u / w;
                res[i] = vec[ux + (uy << 1) * w];
            }
            target.lock();
            r.width  >>= 1, r.height >>= 1;
            target.setVector(r, res);
            target.unlock();
        }
        
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
