/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mIxa
 */

package{
    import flash.geom.Point;
    import caurina.transitions.Tweener;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.utils.*;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;

    public class node extends Sprite{
        private var node1:String;
        private var node2:String;
        private var btn1:Btn;
        private var btn2:Btn;
        private var text1:TextField;
        private var text2:TextField;
        private var sw1:Boolean;
        private var mouse:Point;
        private var scale:Number = 1;//サークルのスケール
        
        
        
        
        
        //コンストラクタ 
        public function node():void{
                    
            
            btn1 = new Btn();
            btn1.init({label:"full screen",type:1,width:100});
            btn1.x = 200; btn1.y = 445;
            addChild(btn1);
            btn2 = new Btn();
            btn2.init({label:"edge",type:1,width:100});
            btn2.x = 310; btn2.y = 445;
            addChild(btn2);
            
  
            btn1.addEventListener("click",fullscreen);
            btn2.addEventListener("click",edge);
            
            text1 = new TextField();
            text1.y = 300;
            text1.text = "test";
            addChild(text1);
            
            text2 = new TextField();
            text2.y = 320;
            text2.text = "test";
            addChild(text2);
            
            // クリックイベントを監視する
            stage.addEventListener("click", clickHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,on_mouseMove);
 
   
        }
        
        private function edge(event:MouseEvent):void{
           if(sw1 == true){
               stage.addEventListener("click", clickHandler);
               btn2.text = "edge";
               sw1 = false;
           }
           else{
               stage.removeEventListener("click", clickHandler); 
               btn2.text = "node";
               sw1 = true;
           }
           event.stopPropagation();//イベントの伝播を止める  
        }

        
        private function on_mouseMove(event:MouseEvent):void{
            text1.text = "x=" + event.stageX + " y="+ event.stageY + " ";
        }

        private var nodeS:Sprite;
        
        //クリック
        private function clickHandler(event:MouseEvent):void {
            // 円を作成
            //var s:Sprite;
            nodeS = new Sprite();
            nodeS.graphics.lineStyle(1,0x000000);
            nodeS.graphics.beginFill(Math.random() * 0x1000000,Math.random()*1.0);
            nodeS.graphics.drawCircle(0, 0, 10);
            nodeS.graphics.endFill();
            addChild(nodeS);
             // イベントリスナー         
            nodeS.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            nodeS.addEventListener( MouseEvent.CLICK , onClick );


            // 円をクリックされた位置に移動
            nodeS.x = event.stageX;
            nodeS.y = event.stageY;
            nodeS.scaleX = nodeS.scaleY = 5;
            nodeS.alpha = 0;
            //アニメーション処理
            Tweener.addTween(nodeS, {
                time: 0.5,    // アニメーション時間
                scaleX: scale,  // s の scaleX を 指定値 まで遷移
                scaleY: scale,  // s の scaleY を 指定値 まで遷移
                alpha: 1,//不透明率
                transition: "easeOutBounce"//バウンドアニメーション
            });     
            
            var timer:Timer = new Timer(500, 1);
            timer.addEventListener(TimerEvent.TIMER, function():void{            
            /*
            //    ロールオーバー            
            s.addEventListener(MouseEvent.ROLL_OVER,function():void{
                Tweener.addTween(s, {
                time: 0.2,    // アニメーション時間
                scaleX: scale*2,  // s の scaleX を 指定値 まで遷移
                scaleY: scale*2,  // s の scaleY を 指定値 まで遷移
                alpha: 100,//不透明率
                transition: "liner"
                });
                text2.text = s.name;
                
            });   

            //    ロールアウト
            s.addEventListener(MouseEvent.ROLL_OUT,function():void{
                Tweener.addTween(s, {
                time: 0.2,    // アニメーション時間
                scaleX: scale,  // s の scaleX を 指定値 まで遷移
                scaleY: scale,  // s の scaleY を 指定値 まで遷移
                alpha: 1,//不透明率
                transition: "liner"
                });
            });     
            */
            });
            
            timer.start();     
        

        }
        
        private function drawEdge(e:Event=null):void{
            graphics.clear();
            graphics.lineStyle(3,0xff0000);
            for(var i:int = 0;i<edgeList.length;i++){
                graphics.moveTo(edgeList[i].node1.x,edgeList[i].node1.y);
                graphics.lineTo(edgeList[i].node2.x,edgeList[i].node2.y);
            }

        }

        
        //画面モード切り替え
        private function fullscreen( event:MouseEvent ):void{          
            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                stage.displayState = StageDisplayState.NORMAL;//元に戻す
                btn1.text = "full screen";
                btn1.onLight = false;
            }
            else{
                stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード
                btn1.text = "normal";
                btn1.onLight = true;
            }
            event.stopPropagation();//イベントの伝播を止める            
        }

        //ノードをクリック
        private function onClick ( event:MouseEvent ):void {
            // URLRequestを設定
            //var url:URLRequest = new URLRequest( "http://wonderfl.net/" );
            // 実際にページに飛ぶ
            //navigateToURL( url );
            event.stopPropagation();//イベントの伝播を止める   
          

        }
            
        //マウスダウンイベントの処理
        private function onMouseDown(evt:MouseEvent):void {
            //ドラッグ開始
            var line:Shape;
            if(sw1 == false){ 
                evt.target.startDrag();
                addEventListener(Event.ENTER_FRAME,drawEdge);
            }
            else{
                node1 = evt.target.name;
                text2.text = node1 + "!";
            }

            evt.stopPropagation();//イベントの伝播を止める
       }

        private var sp:Sprite;
        private var edgeList:Array = new Array();
        //マウスアップイベントの処理
        private function onMouseUp(evt:MouseEvent):void {
            if(sw1 == false){ 
                evt.target.stopDrag();
                removeEventListener(Event.ENTER_FRAME,drawEdge);
            }
            else{//エッジモード
                if(node1!=null){
                    node2 = evt.target.name;
                    if(node2 == null){
                        node1=null;
                        return;
                    }

                   text2.text = evt.target.name+" !!aa ";

                    var obj:Object = new Object();
                    obj.node1 = getChildByName(node1);
                    obj.node2 = getChildByName(node2);
                    edgeList.push(obj);
                    drawEdge();
                    

                    node1 = null;
                }
                
            }

            evt.stopPropagation();//イベントの伝播を止める
            
        }
        


        
    }
}







//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var sw:Boolean;//ライトON/OFF
    
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        
        draw();
    }
    
    public function set text(str:String):void{
        txt.text = str;
    }
    public function get onLight():Boolean{
        return sw;
    }
    public function set onLight(flag:Boolean):void{
        sw = flag;
        light.visible = sw;
    }



    
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
        light.visible = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        //light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        //light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        //light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        //light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}




