/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mI3V
 */

/**
 * Ulam Spiral
 * 素数だけに色を付ける。
 */
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	
	[SWF(backgroundColor = "0x000000", width = "465", height = "465", frameRate = 60)]
	public class Main extends Sprite 
	{
		private var _stageW:uint;
		private var _stageH:uint;
		
		private const UP:uint = 0
		private const RIGHT:uint = 1;
		private const DOWN:uint = 2;
		private const LEFT:uint = 3;
		private const REMAIN_BASE:uint = 2;
		
		private var _count:uint;
		private var _remain:uint;
		private var _distance:uint;
		private var _direction:uint;
		private var _canvasBmd:BitmapData;
		private var _canvas:Bitmap;
		private var _dx:Number;
		private var _dy:Number;
		private var _max:uint;
		private var _now:uint;
		private var _timer:Timer;
		private var _fieldContainer:Sprite;
		private var _format:TextFormat;
		private var _margin:uint;
		/**
		 * constructor
		 */
		public function Main() 
		{
			_stageW = stage.stageWidth;
			_stageH = stage.stageHeight;
			Wonderfl.capture_delay(10);
			_count = 1;
			_remain = 2;
			_distance = 1;
			_direction = RIGHT;
			_dx = 0;
			_dy = 0;
			_now = 1;
			_max = _stageW * _stageH;
			_timer = new Timer(1);
			_canvasBmd = new BitmapData(_stageW, _stageH, false, 0x000000);
			_canvas = new Bitmap(_canvasBmd);
			_fieldContainer = new Sprite();
			_margin = 1;
			
			addChild(_canvas);
			
			//↓一度に描画したければこっち
			//drawAtOnce();
			startTimer();
		}
		/**
		 * startTimer
		 */
		private function startTimer():void 
		{
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);
			_timer.start();
		}
		/**
		 * drawAtOnce
		 */
		private function drawAtOnce():void 
		{
			for (var i:uint = 1; i < _max;i++ )
			{
				timerHandler();
			}
		}
		/**
		 * 数字を表示する場合のtimerHandler
		 * timerHandler
		 * @param 
		 */
		/*
		private function timerHandler(event:TimerEvent = null):void 
		{
			var p:Point = generate(_now);
			var format:TextFormat = new TextFormat();
			format.color = 0x111111;
			format.size = 9;
			if (IsPrime(_now))
			{
				format.color = 0xFF0000;
			}
			var field:TextField = new TextField();
			field.defaultTextFormat = format;
			field.autoSize = "left";
			field.text = String(_now);
			field.selectable = false;
			field.x = _stageW / 2 + p.x;
			field.y = _stageH / 2 + p.y;
			
			_fieldContainer.addChild(field);
			_canvasBmd.lock();
			_canvasBmd.fillRect(_canvasBmd.rect, 0x000000);
			_canvasBmd.draw(_fieldContainer);
			_canvasBmd.unlock();
			
			_now++
			
			if (_now == _max)
			{
				_timer.stop();
				if (_timer.hasEventListener(TimerEvent.TIMER))_timer.removeEventListener(TimerEvent.TIMER, timerHandler);
			}
		}
		*/
		/**
		 * timerHandler
		 * @param 
		 */
		private function timerHandler(event:TimerEvent = null):void 
		{
			var p:Point = generate(_now);
			var color:uint = 0x111111;
			if (IsPrime(_now))
			{
				color = 0xFF0000;
			}
			_canvasBmd.lock();
			//_canvasBmd.fillRect(_canvasBmd.rect, 0x000000);
			_canvasBmd.setPixel(_stageW / 2 + p.x, _stageH / 2 + p.y, color);
			_canvasBmd.unlock();
			_now++
			if (_now == _max)
			{
				_timer.stop();
				if (_timer.hasEventListener(TimerEvent.TIMER))_timer.removeEventListener(TimerEvent.TIMER, timerHandler);
			}
		}
		/**
		 * point
		 * @param number
		 * @return Point
		 */
		private function generate(number:uint):Point
		{
			var returnX:Number = 0;
			var returnY:Number = 0;
			var dx:Number = 0;
			var dy:Number = 0;
			for (;_count < number;_count++)
			{
				if (--_remain == 0) 
				{
					switch (_direction) 
					{
						case UP: _distance++;_direction = LEFT; break;
						case DOWN: _distance++;
						default: _direction--; break;
					}
					
					_remain = _distance;
				}
				switch (_direction) 
				{
					case LEFT: --dx; break;
					case RIGHT: ++dx; break;
					case UP: --dy; break;
					case DOWN: ++dy; break;
				}
			}
			returnX = _dx + dx;
			returnY = _dy + dy;
			_dx += dx;
			_dy += dy;
			return new Point(returnX * _margin, returnY * _margin);
		}
		/**
		 * IsPrime
		 * @param n
		 * @return
		 */
		private function IsPrime(number:uint):Boolean
		{
			if (number < 2)
			{
				return false;
			}
			else if (number == 2)
			{
				return true;
			}
			if (number % 2 == 0)
			{
				return false;
			}
			var i:uint = 0;
			for (i = 3; i * i <= number; i += 2)
			{
				if (number%i==0)
				{
					return false;
				}
			}
			return true;
		}
	}
}