/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mHfM
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
        public function FlashTest()
        {
            
            
            vecAct = new Vector.<xActor>;
            
            var a:xActor;
            var i:int;
            
            for (i = 0; i < 16; i++)
            {
                a = new xActor();
                a.cx = 30 + Math.random() * 300;
                a.cy = 30 + Math.random() * 300;
                vecAct.push(a);
            }//nexti
            
         stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
         stage.addEventListener(KeyboardEvent.KEY_UP, kup);
         stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
         stage.addEventListener(MouseEvent.MOUSE_UP, mup);  
         stage.addEventListener(Event.ENTER_FRAME, onEnter); 
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
        public function kdown(e:KeyboardEvent):void { if (e.keyCode >511){return;} vecKey[e.keyCode]=true;}
        public function kup(e:KeyboardEvent):void { if (e.keyCode > 511) {return;} vecKey[e.keyCode]=false;}
        
        public var bMdown:Boolean = false;
        public var selx:Number = 0;
        public var sely:Number = 0;
        
        public var vecAct:Vector.<xActor>;
        public var vecSel:Vector.<xActor> = new Vector.<xActor>(1024, false);
        public var numSel:int = 0;
        
        public function mdown(e:MouseEvent):void
        {
            if (vecKey[Keyboard.CONTROL]) 
            { 
             bMdown = false; 
              sendSel(stage.mouseX, stage.mouseY);
             return; 
            }
            
            
            bMdown = true;
            selx = stage.mouseX;
            sely = stage.mouseY;
        }//mdown
        
        public function mup(e:MouseEvent):void
        { 
            if (vecKey[Keyboard.CONTROL]) { return; }
        
            bMdown = false;
            selAct(stage.mouseX, stage.mouseY, selx, sely);
        }//mup
        
        
        public function sendSel(ax:Number, ay:Number):void
        {
            var i:int;
            var num:int;
            var a:xActor;
            
            var kx:Number;
            var ky:Number;
            
            num = numSel;
            
            kx = 0;
            ky = 0;
            
            for (i = 0; i < num; i++)
            {
                a = vecSel[i];
                kx += a.cx;
                ky += a.cy;
            }//nexti  
            
            kx /= num;
            ky /= num;
            
            for (i = 0; i < num; i++)
            {
                a = vecSel[i];
                 a.gx = ax + (a.cx-kx);
                 a.gy = ay + (a.cy-ky);

                //todo -- if there are obstacles about
                //raycast from (ax,ay) to (a.cx-kx,a.cy-ky) first

                 a.move = 1;
                 
            }//nexti
            
        }//sendsel
        
        public function selAct(ax:Number, ay:Number, bx:Number, by:Number):void
        {
            var temp:Number;
            
            if (ax > bx) { temp = ax; ax = bx; bx = temp; }
            if (ay > by) { temp = ay; ay = by; by = temp; }
            
            var i:int;
            var num:int;
            var a:xActor;
            
            numSel = 0;
            
            num = vecAct.length;
            
            for (i = 0; i < num; i++)
            {
                a = vecAct[i];
                
                if (a.cx + a.rad < ax) { continue; }
                if (a.cy + a.rad < ay) { continue; }
                if (a.cx - a.rad > bx) { continue; }
                if (a.cy - a.rad > by) { continue; }
                
                vecSel[numSel] = a;
                numSel += 1;
                if (numSel > 1023) { break; }
            }//nexti
            
        }//selact
        
        
        public function drawRect(ax:Number, ay:Number, bx:Number, by:Number):void
        {
            var temp:Number;
            
            if (ax > bx) { temp = ax; ax = bx; bx = temp; }
            if (ay > by) { temp = ay; ay = by; by = temp; }
            
            graphics.drawRect(ax,ay, bx-ax, by-ay);
            
        }//drawrect
        
        
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            var mx:Number;
            var my:Number;
            
            mx = stage.mouseX;
            my = stage.mouseY;
            
            if (vecKey[Keyboard.CONTROL]) { bMdown = false;}
            
            if (bMdown)
            {
                 drawRect(mx,my, selx, sely);
                 
            }//endif
            
            var num:int;
            var i:int;
            var a:xActor;
            
            var dx:Number;
            var dy:Number;
            var ang:Number;
            
            num = vecAct.length;
            
            for (i = 0; i < num; i++)
            {
                a = vecAct[i];
                
                a.vx *= 0.99;
                a.vy *= 0.99;
                
                a.cx += a.vx;
                a.cy += a.vy;
                
                graphics.drawCircle(a.cx, a.cy, a.rad);
                
                if (a.move <= 0) { continue; }
                
                dx = a.gx - a.cx;
                dy = a.gy - a.cy;
                ang = Math.atan2(dy, dx);
                a.vx = Math.cos(ang)*a.speed;
                a.vy = Math.sin(ang)*a.speed;
                
                if (Math.abs(dx) <= a.speed && Math.abs(dy) <= a.speed) 
                { a.move = 0; a.vx =0; a.vy = 0;}
                
                graphics.moveTo(a.cx,a.cy);
                graphics.lineTo(a.gx,a.gy);
                
            }//nexti
            
            
            graphics.lineStyle(2, 0xFF, 0.7);
            
            num = numSel;
            
            for (i = 0; i < num; i++)
            {
                a = vecSel[i];
                
                graphics.drawRect(a.cx-10, a.cy-10,20,20);
            }//nexti
            
            
        }//onenter
        
        
        
    }//classend
}

internal class xActor
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public var rad:Number = 8;
    public var speed:Number = 4;
    
    public var gx:Number = 0;
    public var gy:Number = 0;
    
    public var move:int = 0;
    
}//xactor