/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mHS8
 */

package  
{
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.navigateToURL;
	import flash.net.URLRequest;
	import net.wonderfl.utils.WonderflSWFUrl;
	
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	import net.wonderfl.math.WMath;
	
	[SWF(width="465", height="465", frameRate="30")]
	public class Test extends Sprite
	{
		private var _currentAngle:Number = 0;
		private var _arrow:Arrow;
		private var _followingMouse:Boolean = false;
		
		public function Test() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			showTexts();
			
			_arrow = new Arrow;
			_arrow.x = 232.5;
			_arrow.y = 232.5;
			addChild(_arrow);
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, followMouse);
		}
		
		private function followMouse(e:MouseEvent):void 
		{
			_followingMouse = true;
			var angle:Number = Math.atan2(mouseY - 232.5, mouseX - 232.5);
			var currentAngle:Number = _arrow.rotation * Math.PI / 180;
			var diff:Number = angle - currentAngle;
			diff += 2 * Math.PI;
			diff %= 2 * Math.PI;
			
			if (diff > Math.PI)
				diff -= 2 * Math.PI;
				
			angle += diff;
			angle *= 180 / Math.PI;
			
			Tweener.addTween(_arrow, {rotation: angle ,time:2.0, onComplete:removeFlag} );
		}
		
		private function removeFlag():void
		{
			_followingMouse = false;
		}
		
		private function showTexts():void {
			var tf:TextField = new TextField;
			tf.x = 20;
			tf.width = 350;
			
			tf.text = "Algorithm:\n\n";
			tf.appendText("var angle:Number = Math.atan2(mouseY - 232.5, mouseX - 232.5);\n" + 
			"angle *= 180 / Math.PI;");
			tf.setTextFormat(new TextFormat("_sans", 12, 0, true), 0, 10);
			
			tf.mouseEnabled = false;
			tf.selectable = false;
			addChild(tf);
			
			tf = new TextField;
			tf.text = "Place mouse cursor around here.\nThe arrow doesn't follow as you might guess. What's wrong with the algorithm?";
			tf.selectable = false;
			tf.wordWrap = true;
			tf.mouseEnabled = false;
			tf.width = 160;
			tf.x = 20;
			tf.y = 205;
			addChild(tf);
			
			var sp:Sprite = new Sprite;
			tf = new TextField;
			tf.selectable = false;
			tf.mouseEnabled = false;
			tf.width = 200;
			tf.htmlText = "<u><b>see bug fixed version</b></u>";
			tf.y = 420;
			tf.x = 320;
			sp.graphics.beginFill(0, 0);
			sp.buttonMode = true;
			sp.graphics.drawRect(0, 0, tf.width, tf.height);
			sp.addEventListener(MouseEvent.CLICK, function () {
				navigateToURL(new URLRequest("http://wonderfl.net/code/9a9f97ebc491f368efa72aa91c2a8ab1c6529311"), "_blank");
			});
			sp.addChild(tf);
			addChild(sp);
		}
	}
}

import flash.display.Sprite

class Arrow extends Sprite {
	private const HUNIT:int = 8;
	private const VUNIT:int = 6;
	
	public function Arrow() {
		graphics.lineStyle(1);
		graphics.moveTo( -HUNIT, VUNIT);
		graphics.lineTo(3 * HUNIT, VUNIT);
		graphics.lineTo(3 * HUNIT, 3 * VUNIT);
		graphics.lineTo(5 * HUNIT, 0);
		graphics.lineTo(3 * HUNIT, -3 * VUNIT);
		graphics.lineTo(3 * HUNIT, -VUNIT);
		graphics.lineTo( -HUNIT, -VUNIT);
		graphics.lineTo( -HUNIT, VUNIT);
	}
}