/**
 * Copyright dsdseg ( http://wonderfl.net/user/dsdseg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mH2d
 */

package {

import flash.text.*;
import flash.text.engine.*;
import flash.display.*;

[SWF(frameRate="12",width="100",height="540")]
public class Tategaki extends Sprite
{
    private static const kMessage:String = "こんにちは、世界! Hello, World";

    /** 縦書きサンプル
     */
    public function Tategaki() {
        main();
    }

    /** main
    * 日本語・半角英数字混じりの文の縦書きサンプル (最小限の)
    * デフォルトだと半角英数字は右に90°転んで表示されるので、
    * 明示的に回転させて縦に表示されるようにする
    */
    public function main():void {
        // テキストブロック作成
        var textBlock:TextBlock = new TextBlock();
        var font:FontDescription = new FontDescription();
        // テキストフォーマット作成
        var format:ElementFormat = new ElementFormat();
        format.locale = "ja"; // default: "ja"
        format.fontSize = 24;
        format.color = 0x0000FF;
        //format.baselineShift = 5;

        // 改行文字による折り返しなし指定
        format.breakOpportunity = BreakOpportunity.NONE;
        // 縦書き文字列内の半角英数字を回転させて縦に表示する
        format.textRotation = TextRotation.ROTATE_270;
        format.dominantBaseline = TextBaseline.IDEOGRAPHIC_CENTER;
        var eaj:TextJustifier = new EastAsianJustifier();
        //textBlock.baselineZero = TextBaseline.IDEOGRAPHIC_CENTER;
        textBlock.textJustifier = eaj;

        textBlock.content = new TextElement(kMessage, format);
        //行を回転させることで"縦書き"に設定
        textBlock.lineRotation = TextRotation.ROTATE_90;
        var prevLine:TextLine = null;
        font.fontName = "MS Gothic";
        var tline:TextLine = textBlock.createTextLine(prevLine);
        addChild(tline);
        tline.x = 40;
    }
}
}
