///////////////////////////////////////////////////////////
// The 25-Line ActionScript Contestの
// November/December Finalistsの Entry 059を移植した。
// オリジナルより読みやすいと思う。
// オリジナルはBen Morrison氏作
// クリックで３Ｄモードを切り替え
// ESCキーでカラーモードが切り替わります。
///////////////////////////////////////////////////////////

/**
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

package  
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.geom.Matrix;
	import flash.geom.Matrix3D;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.utils.getTimer;
	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=24)]

	public class TVDot extends Sprite
	{
		private var screen:Sprite;
		private var tf:TextField;
		private var colorMode:int = 0;
		private var mode:Boolean = true;	//3D
		private var textColors:Array = [0xFFFFFF, 0x000000, 0x000000];
		private var bmpW:int = 40;//横方向のドットの数
		private var bmpH:int = 24;//縦方向のドットの数
		private var bmp:BitmapData;
		private var dotSize:Number = 24;
		private var tx:Number = 45;
		private var scrollx:Number = 2;

		public function TVDot() 
		{
			addEventListener(Event.ADDED_TO_STAGE, addedToStage);
		}
		
		private function addedToStage(e:Event):void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.addEventListener(MouseEvent.CLICK, clickHandler);
			addChild(screen = new Sprite());
			screen.transform.matrix3D = new Matrix3D(Vector.<Number>([
					1, 0, 0, 0,
					0, 1, 0, 0,
					0, 0, 1, 0,
					465*0.5, 465*0.5, 450, 1]));
			
			tf = new TextField();
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.defaultTextFormat = new TextFormat("_sans", 22);
			tf.text = "upclose: an experiment with virtual lcd pixels. [esc] change color mode, click toggles 3d, keyboard edits text";
			tf.type = TextFieldType.INPUT;
			tf.setSelection(tf.text.length, tf.text.length);
			tf.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			
			bmp = new BitmapData(bmpW, bmpH, false, 0x000000);

			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function keyDownHandler(e:KeyboardEvent):void 
		{
			if (e.keyCode == 27) {
				colorMode = (colorMode + 1) % 3;
			}
		}
		
		private function clickHandler(e:MouseEvent):void 
		{
			mode = !mode;
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			stage.focus = tf;
			screen.graphics.clear();
			
			tf.textColor = textColors[colorMode];
			
			var c:uint = [
			0xFFFFFFFF,
			0xFF000000 + 0x010000 * (int((Math.sin(getTimer()/1200)+1)*128)) + 0x000100 * (int((Math.sin(getTimer()/1000) + 1) * 128)) + 0x000001 * (int((Math.sin(getTimer() / 800) + 1) * 128)),
			0xFFFFFFFF][colorMode];
			bmp.fillRect(bmp.rect, c);
			if (colorMode == 0) {
				bmp.perlinNoise(bmpW, bmpH, 1, 10, false, false, 7, false, [new Point( -getTimer() / 50, 0)]);
			}

			tx = tx < -tf.width + 8 ? bmp.width : tx - scrollx;
			bmp.draw(tf, new Matrix(1, 0, 0, 1, tx, -3));
			var color:uint;
			var r:uint;
			var g:uint;
			var b:uint;
			var x:Number;
			var y:Number;
			var w:Number = dotSize / 3;
			var h:Number = dotSize;
			var er:Number = 3;

			for (var j:int = 0; j < bmp.height; j++) {
				for (var i:int = 0; i < bmp.width; i++) {
					color = bmp.getPixel(i , j);
					r = color & 0xFF0000;
					g = color & 0x00FF00;
					b = color & 0x0000FF;
					
					x = i * dotSize + i * 0.5  - dotSize * (bmpW + 1) * 0.5 + 2;
					y = j * dotSize + j - dotSize * (bmpH+1) * 0.5;
					screen.graphics.beginFill(r);
					screen.graphics.drawRoundRect(x, y, w, h, er);
					screen.graphics.endFill();

					x = i * dotSize + i * 0.5 + dotSize / 3 - dotSize * (bmpW + 1) * 0.5 + 2;
					screen.graphics.beginFill(g);
					screen.graphics.drawRoundRect(x, y, w, h, er);
					screen.graphics.endFill();
					
					x = i * dotSize + i * 0.5 + 2 * dotSize / 3 - dotSize * (bmpW + 1) * 0.5 + 2;
					screen.graphics.beginFill(b);
					screen.graphics.drawRoundRect(x, y, w, h, er);
					screen.graphics.endFill();
				}
			}

			
			screen.z 		 -= (screen.z 		  - (mode ? 50 : 450)) / 2;
			screen.rotationY -= (screen.rotationY - (mode ? -screen.mouseX/45 : 0)) / 2;
			screen.rotationX -= (screen.rotationX - (mode ? -screen.mouseY/45 : 0)) / 2;
		}
		
	}
	
}