/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mEwU
 */

package
{
     
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
     
    import mx.collections.ArrayList;
    import mx.core.UIComponent;
     
    public class CircleTextField extends Sprite
    {
        public var circleRadius:Number;                     
        public var component:UIComponent;
        public var text:String = "lalalal";
         
        public function CircleTextField(component:UIComponent, text:String, circleRadius:Number, font:String, fontSize:Number, fontColor:uint):void
        {
             
            this.text = text;
            this.component = component;
            this.circleRadius = circleRadius;           
             
            var textFormat:TextFormat = new TextFormat();
            textFormat.font = font;
            textFormat.size = fontSize;
            textFormat.align = TextFormatAlign.CENTER;
            textFormat.color = fontColor;
             
            var textFieldHeight:Number = fontSize;          
            var textFields:ArrayList = new ArrayList();
                     
         
            var circleSprite:Sprite = new Sprite;
            circleSprite.graphics.beginFill(0x000000, 0.5);
            circleSprite.graphics.drawCircle(0, 0, circleRadius);
            circleSprite.graphics.endFill();
            addChild(circleSprite);
       
 
            // general algorithm
            // fill in text fields, if need additional text field
            // create one and reposition everything so to center text in circle
            // keep going until run out of text
             
            var shouldAddTextField:Boolean = true;
            var currentTextFieldIndex:Number = 0;
            var maxTextFieldsReached:Boolean = false;
             
            for(var i:Number=0;i < text.length;i++)
            {   
                 
                // add text field to list
                if(shouldAddTextField) {
                             
                    if(-((textFields.length+1) * textFieldHeight)/2 < -circleRadius) { // check if reached max number of textfields
                         
                        maxTextFieldsReached = true;                        
                    }
                    else {
 
                        var newTextField:TextField = new TextField();
                        newTextField.defaultTextFormat  = textFormat;
                        newTextField.wordWrap = true;
                        newTextField.multiline = false;
                        newTextField.selectable = false;
                        newTextField.embedFonts = true;
                        addChild(newTextField);                 
                        textFields.addItem(newTextField);
                         
                    }
 
                 
                    newTextField.background = true;
                    newTextField.backgroundColor = 0xFF0000;
                    newTextField.alpha = 0.5;
               
                     
                    var textFieldsHeight:Number = (textFields.length * textFieldHeight);
                    var y:Number = -textFieldsHeight/2;
                         
                    for(var j:Number=0;j<textFields.length;j++)
                    {
                        var textField:TextField = TextField(textFields.getItemAt(j));
                        textField.y = y + j*textFieldHeight;                        
                        textField.text = "";
                         
                        // calculate width of text field based on y position and circle equations
                        var tfy:Number;
                        if(textField.y < 0) {
                            tfy = Math.abs(textField.y);
                            textField.width = 2*Math.sqrt((circleRadius * circleRadius) - (tfy * tfy));
                        }
                        else {
                            tfy = Math.abs(textField.y + textFieldHeight);
                            textField.width = 2*Math.sqrt((circleRadius * circleRadius) - (tfy * tfy));                         
                        }   
                         
                        textField.x = -textField.width/2;
                         
 
                    }
                     
                    i = 0;
                    currentTextFieldIndex = 0;  
                    shouldAddTextField = false;
 
                                                         
                }               
                                 
                var currentTextField:TextField = TextField(textFields.getItemAt(currentTextFieldIndex));
                 
                currentTextField.appendText(text.substring(i, i + 1));
 
                if(currentTextField.numLines > 1) // wrap detected
                {           
                    var foundSpace:Boolean = false;
                    for(var k:Number = currentTextField.text.length-1; k >= 0; k -= 1) // look for space 
                    {
                        if(currentTextField.text.substring(k-1, k) == " ") {
                            i = i-(currentTextField.text.length-k); // return to where space is
                            currentTextField.text = currentTextField.text.substring(0, k); // chop text at space
                            foundSpace = true;
                            break;
                        }
                    }
                    if(foundSpace == false) {
                        // hard wrap, continually remove letters until fits within width
                        for(var m:Number = currentTextField.text.length-1; m >= 0; m -= 1)
                        {
                            i = i-(currentTextField.text.length-m);
                            currentTextField.text = currentTextField.text.substring(0, m);                          
                            if(currentTextField.numLines == 1) { // fits without wrapping
                                break;
                            }                           
                        }
                    }
 
                    currentTextFieldIndex++;
                    if(currentTextFieldIndex < textFields.length) {
                        // do nothing, keep filling
                    }
                    else {
                         
                        if(maxTextFieldsReached == false) {
                            shouldAddTextField = true;
                        }
                        else {
                             
                            if(currentTextField.text.length >= 3) {
                                currentTextField.text = currentTextField.text.substr(0, currentTextField.text.length - 1 - 3) + "..."; 
                            }                               
                             
                            break;
                        }
                    }
                }
             
            }
 
             
        }
 
    }
}