/**
 * Copyright ecjtu.leon49 ( http://wonderfl.net/user/ecjtu.leon49 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mEU7
 */

// forked from clockmaker's Arrows using Starling
// forked from clockmaker's BitmapDataで配列に格納すると高速化するよ
// forked from clockmaker's 3D Flow Simulation with Field of Blur
// forked from clockmaker's 3D Flow Simulation
// forked from clockmaker's Interactive Liquid 10000
// forked from clockmaker's Liquid110000 By Vector
// forked from munegon's forked from: forked from: forked from: forked from: Liquid10000
// forked from Saqoosha's forked from: forked from: forked from: Liquid10000
// forked from nutsu's forked from: forked from: Liquid10000
// forked from nutsu's forked from: Liquid10000
// forked from zin0086's Liquid10000
package
{
    import com.bit101.components.NumericStepper;
    
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.display.MovieClip;
    
    import starling.core.Starling;

    [SWF(frameRate = "60", width = "465", height = "465", backgroundColor = "#FFFFFF")]
    
    public class StarlingPerformance extends MovieClip
    {

        //----------------------------------------------------------
        //
        //   Static Property 
        //
        //----------------------------------------------------------

        public static const FIRST_NUM:uint = 5000;

        //----------------------------------------------------------
        //
        //   Constructor 
        //
        //----------------------------------------------------------

        public function StarlingPerformance()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;

            var mStarling:Starling = new Starling(StarlingPart, stage);
            mStarling.showStats = true;
            mStarling.enableErrorChecking = false;
            mStarling.start();

            ns = new NumericStepper(this, 0, 433, changeHandler);
            ns.scaleX = ns.scaleY = 2;
            ns.value = FIRST_NUM;
            ns.step = 1000;
        }

        //----------------------------------------------------------
        //
        //   Property 
        //
        //----------------------------------------------------------

        private var ns:NumericStepper;

        //----------------------------------------------------------
        //
        //   Function 
        //
        //----------------------------------------------------------

        private function changeHandler(e:Event):void
        {
            StarlingPart.instance.reset(ns.value);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

import starling.display.Image;
import starling.display.QuadBatch;
import starling.display.Sprite;
import starling.events.Event;
import starling.textures.Texture;

internal final class StarlingPart extends Sprite
{

    //----------------------------------------------------------
    //
    //   Static Property 
    //
    //----------------------------------------------------------

    public static var instance:StarlingPart;
    private static const STAGE_H:int = 465;
    private static const STAGE_W:int = 465;
    private static const MAX:int = 8190;

    //----------------------------------------------------------
    //
    //   Constructor 
    //
    //----------------------------------------------------------

    public function StarlingPart()
    {
        instance = this;

        addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
    }

    //----------------------------------------------------------
    //
    //   Property 
    //
    //----------------------------------------------------------

    private var first:Particle;
    private var forceMap:BitmapData = new BitmapData(465, 465, false, 0x000000);
    private var image:Image;
    private var offset:Array = [new Point(), new Point()];
    private var quadBatchs:Vector.<QuadBatch>;
    private var randomSeed:uint = Math.floor(Math.random() * 0xFFFF);
    private var seed:Number = Math.floor(Math.random() * 0xFFFF);

    //----------------------------------------------------------
    //
    //   Function 
    //
    //----------------------------------------------------------

    public function reset(numObj:uint):void
    {
        var i:int;

        if (quadBatchs)
        {
            for (i = 0; i < quadBatchs.length; i++)
            {
                quadBatchs[i].dispose();
                removeChild(quadBatchs[i]);
            }
        }

        var len:int = Math.ceil(numObj / MAX);
        quadBatchs = new Vector.<QuadBatch>();
        for (i = 0; i < len; i++)
        {
            quadBatchs[i] = new QuadBatch();
            addChild(quadBatchs[i]);
        }

        var old:Particle;
        for (i = 0; i < numObj; i++)
        {
            var p:Particle = new Particle();
            p.x = stage.stageWidth * Math.random();
            p.y = stage.stageWidth * Math.random();
            p.vx = 0;
            p.vy = 0;
            if (old)
                old.next = p;
            if (i == 0)
                first = p;
            old = p;
        }
    }

    final private function addedToStageHandler(event:Event):void
    {
        this.touchable = false;

        // 矢印をプレレンダリング
        var arrow:Shape = new Shape();
        arrow.graphics.beginFill(0xFFFFFF, 1);
        arrow.graphics.lineStyle(1, 0x0, 1);
        arrow.graphics.moveTo(2, 4);
        arrow.graphics.lineTo(8, 4);
        arrow.graphics.lineTo(8, 0);
        arrow.graphics.lineTo(20, 7);
        arrow.graphics.lineTo(8, 14);
        arrow.graphics.lineTo(8, 10);
        arrow.graphics.lineTo(2, 10);
        arrow.graphics.lineTo(2, 4);

        var bmd:BitmapData = new BitmapData(20, 14, true, 0x00000000);
        bmd.draw(arrow);
        var texture:Texture = Texture.fromBitmapData(bmd, false);

        image = new Image(texture);
        image.pivotX = image.width >> 1;
        image.pivotY = image.height >> 1;

        // フォースマップの初期化をおこないます
        resetFunc();
        // 時間差でフォースマップと色変化の具合を変更しています
        var timer:Timer = new Timer(2000)
        timer.addEventListener(TimerEvent.TIMER, resetFunc);
        timer.start();

        reset(StarlingPerformance.FIRST_NUM);

        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }

    final private function enterFrameHandler(event:Event):void
    {
        var p:Particle = first;
        var color:Number;

        var i:int;

        for (i = 0; i < quadBatchs.length; i++)
            quadBatchs[i].reset();

        var cnt:int = 0;
        while (p.next)
        {
            color = forceMap.getPixel(p.x >> 0, p.y >> 0);
            p.ax += ((color & 0xff) - 0x80) * .0005;
            p.ay += ((color >> 8 & 0xff) - 0x80) * .0005;
            p.vx += p.ax;
            p.vy += p.ay;
            p.x += p.vx;
            p.y += p.vy;
            
            var posX:Number = p.x;
            var posY:Number = p.y;

            var rot:Number = + Math.atan2(p.vy, p.vx);
            p.rot = rot;
            p.ax *= .96;
            p.ay *= .96;
            p.vx *= .92;
            p.vy *= .92;

            (posX > STAGE_W) ? p.x = 0 :
                (posX < 0) ? p.x = STAGE_W : 0;
            (posY > STAGE_H) ? p.y = 0 :
                (posY < 0) ? p.y = STAGE_H : 0;

            image.x = p.x;
            image.y = p.y;
            image.rotation = p.rot;
            quadBatchs[cnt / MAX >> 0].addImage(image);

            p = p.next;
            cnt++;
        }
    }
    
    final private function resetFunc(e:TimerEvent = null):void
    {
        forceMap.perlinNoise(117, 117, 3, seed, false, true, 6, false, offset);

        offset[0].x += 1.5;
        offset[1].y += 1;
        seed = Math.floor(Math.random() * 0xFFFFFF);
    }
}

internal class Particle extends Bitmap
{

    //----------------------------------------------------------
    //
    //   Constructor 
    //
    //----------------------------------------------------------

    public function Particle()
    {
    }

    //----------------------------------------------------------
    //
    //   Property 
    //
    //----------------------------------------------------------

    public var ax:Number = 0;
    public var ay:Number = 0;
    public var next:Particle;
    public var rot:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
}
