/**
 * Copyright ysle ( http://wonderfl.net/user/ysle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mDw2
 */

package  
{
	import flash.display.Loader;
	import flash.display.Sprite
	import flash.events.MouseEvent;
	import flash.filters.BevelFilter;
	import flash.net.navigateToURL;
	import flash.net.NetConnection;
	import flash.net.Responder;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(width = 450, height = 450, backgroundColor = 0xffffff, frameRate = 30)]
	public class UstreamDemo extends Sprite
	{
		public function UstreamDemo() 
		{
			stage.scaleMode = 'noScale'

			var gw:NetConnection = new NetConnection()
			gw.connect('http://rgw.ustream.tv/gateway.php')
			gw.call('Ustream.listLive', new Responder(onGetData), { featured:false, allServer:true } )
		}

		private function onGetData(data:Object):void
		{
			graphics.beginFill(0x1d8cca)
			graphics.drawRect(0, 0, 10, 450)
			for (var c:int = 0; c < data.channels.length; c++) addChild(render(data.channels[c])).y = 45 * c
		}

		private function render(data:Object):Sprite
		{
			var renderer:Sprite
			var loader:Loader 
			var tf:TextField 

			with (renderer = new Sprite())
			{
				graphics.beginFill(0xffffff)
				graphics.drawRect(0, 0, 450, 45)
				filters = [new BevelFilter(20, 90, 0, 0, 0x1d8cca, .1, 0, 20, 1, 3)]

				mouseChildren = false
				buttonMode = useHandCursor = true
				name = data.channelId

				addEventListener('mouseOver',function(e:MouseEvent):void{e.target.x = 10})
				addEventListener('mouseOut', function(e:MouseEvent):void { e.target.x = 0 } )
				addEventListener('click', function(e:MouseEvent):void { navigateToURL(new URLRequest('http://ustream.tv/channel/' + e.target.name)) } )

				with (addChild(loader = new Loader()))
				{
					load(new URLRequest(data.thumbnailUrl))
					scaleX = scaleY = .5
				}

				with (addChild(tf = new TextField()))
				{
					x = 70
					y = 5
					defaultTextFormat = new TextFormat('verdana', 12, 0x1d8cca)
					autoSize = 'left'
					multiline = true
					htmlText = '<b>' + data.channelTitle + '</b><br/>' + data.viewerNumber +' viewer' + (data.viewerNumber > 1?'s':'')
				}
			}
			return renderer
		}
	}
}