/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mDe1
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.Timer;
    
    import com.flashdynamix.utils.SWFProfiler;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "000000")]
    public class Main extends Sprite
    {
        private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        private static const CTF:ColorTransform = new ColorTransform(0.5, 0.5, 0.5, 0.8);
        private var _clockBM:BitmapData;
        private var _clockText:TextField;
        private var _txt:TextField;
        private var _tf:TextFormat;
        private var _timer:Timer;
        private var _canvas:Bitmap;
        private var _canvas_bmd:BitmapData;
        /**
         * コンストラクタ
         *
         * @access public
         * @param
         * @return
         */
        public function Main()
        {
            init();
        }
        
        /**
         * init
         *
         * @access private
         * @param
         * @return void
         */
        private function init():void
        {
            // SWFProfiler
            SWFProfiler.init(this);            
            
            // Timer
            var timer:Timer = new Timer(1000, 0);  
            timer.addEventListener(TimerEvent.TIMER, timerHandler);  
            timer.start();            
               
            // 時計表示用text
            _clockText = new TextField();
            _clockBM = new BitmapData(WIDTH, HEIGHT, true, 0xFFFFFFFF);
            
            // 時計描画用canvas
            _canvas_bmd = new BitmapData(WIDTH, HEIGHT, true, 0xFF000000);
            _canvas = new Bitmap(_canvas_bmd);
            addChild(_canvas);    
            
            // 数字用TextField
            _txt = new TextField();
            _txt.textColor = 0x00FF00;
            _txt.width = WIDTH;
            _txt.height = HEIGHT;
            //_txt.wordWrap = true;
            
            // 数字用TextFormat
            _tf = new TextFormat();
            //_tf.size = 11;
            _tf.align = TextFormatAlign.JUSTIFY;
            
            // ENTER_FRAMEイベント
            addEventListener(Event.ENTER_FRAME, enterFrameHandler)
        }
        
        /**
         * enterFrameHandler
         *
         * @access private
         * @param e ENTER_FRAMEイベント
         * @return void
         */
        private function enterFrameHandler(e:Event):void
        {
            var numW:Number = 6.2;
            var str:String = "";
            var w:int = WIDTH / numW;
            var h:int = HEIGHT / numW;
            
            _txt.htmlText = "";
            
            // bitmapイメージの変更のロック
            _canvas_bmd.lock();
            // bitmapイメージの色を変換
            _canvas_bmd.colorTransform(_canvas_bmd.rect, CTF);
            
            
            for (var i:int = 0; i < w; i++ )        
            {
                for (var j:int = 0; j < h; j++ )
                {
                    // 文字がある箇所
                    if (_clockBM.getPixel(j, i) != 0xFFFFFF) {
                        // 背景と同じ色の0でごまかす
                        str += "<font color='#000000'>0</font>";
                    }else {
                        var char:String = String(Math.floor((Math.random() * 10)));
                        str += char;
                    }
                }
                str += "\n";
            }
            
            _txt.htmlText += str;
            _txt.setTextFormat(_tf);

            // 数字をbitmapとして描画
            _canvas_bmd.draw(_txt);            
            
            // bitmapイメージの変更のロックを解除
            _canvas_bmd.unlock();
        }
        
        /**
         * timerHandler
         *
         * @access private
         * @param e TimerEvent.TIMERイベント
         * @return void
         */
        private function timerHandler(e:TimerEvent):void
        {
            var now:Date = new Date();
            var h:int = now.getHours();
            var m:int = now.getMinutes();
            var s:int = now.getSeconds();
            var hourStr:String;
            var minStr:String;
            var secStr:String;
            
            if (h < 10)    {
                hourStr = "0" + h;
            } else {
                hourStr = h.toString();
            }
            
            if (m < 10) {
                minStr = "0" + m;
            } else {
                minStr = m.toString();
            }
            
            if (s < 10 ) {
                secStr = "0" + s;
            } else {
                secStr = s.toString();
            }
          
            timerDisplay(hourStr +":"+ minStr +":"+ secStr);
        }
        
        /**
         * timerDisplay
         *
         * @access private
         * @param e ENTER_FRAMEイベント
         * @return void
         */
        private function timerDisplay(str:String):void
        {            
            // 座標移動
            var mat:Matrix = new Matrix();
            mat.translate(1, 8);
            
            _clockText.htmlText = "<font color='#000000' face='Arial' size='18'>" + str + "</font>";
            
            // いったん塗りつぶし
            _clockBM.fillRect(_clockBM.rect, 0xFFFFFFFF);
            // 時間をbitmapとして描画
            _clockBM.draw(_clockText, mat);
        }
    }
}