/**
 * Copyright knd ( http://wonderfl.net/user/knd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mDci
 */

// forked from checkmate's Saqoosha challenge for amateurs
package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.ByteArray;
	
	[SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=30)]

	public class GradationTest1 extends Sprite {
		
		private var size:Number = 465;
		private var vid:Video;
		
		private var gradientSteps: uint = 1000; //グラデーションを何段階に分解するか
		private var colorTable:Vector.<uint> = new Vector.<uint>();
		
		private var bmd:BitmapData;
		private var bmp:Bitmap;
		private var aura:BitmapData;

		public function GradationTest1() {

			var cam:Camera = Camera.getCamera();
			cam.setMode(size, size, 30);
			vid = new Video(size, size);
			vid.attachCamera(cam);
			
			var grad:Gradation = new Gradation(0x000000, 0x0000ff, 0x33ff00, 0xffcc00, 0xff0033, 0xffffff);
			//grad.setEasing(Sine.easeIn);
			for (var i:int = 0; i < gradientSteps; i++) {
				// getColorでグラデーションを構成する中間色を取り出す。渡す値は0?1。滑らかにこの値を変化させることでグラデーションを作り出す。
				colorTable.push(grad.getColor(i / gradientSteps));
			}

			bmd = new BitmapData(465, 465);
			aura = new BitmapData(465, 465);
			bmp = new Bitmap(bmd);
			bmp.filters = [new BlurFilter(16, 16, 1)];
			addChild(bmp);

			if(cam) addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			bmd.lock();
			bmd.draw(vid);
			
			//中間色のピクセルからオーラを立ち上らせる
			bmd.draw(aura, new Matrix(1, 0, 0, 1, 2 * (Math.random() - 0.5), -4));
			aura.threshold(bmd, bmd.rect, new Point(), "!=", 0x707070, 0, 0xf0f0f0, true);
			aura.draw(aura, new Matrix(1, 0, 0, 1, 2 * (Math.random() - 0.5), -4));
			aura.colorTransform(aura.rect, new ColorTransform(1, 1, 1, 0.99));
			
			var baIn: ByteArray = bmd.getPixels(bmd.rect);
			baIn.position = 0;
			var baOut: ByteArray = new ByteArray();
			var ct:Vector.<uint> = colorTable;
			//輝度に変換
			//赤:0.29891 緑:0.58661 青:0.11448
			var kr:Number = gradientSteps * 0.29891 / 256;
			var kg:Number = gradientSteps * 0.58661 / 256;
			var kb:Number = gradientSteps * 0.11448 / 256;
			var a:uint;
			var r:uint;
			var g:uint;
			var b:uint;
			var idx:int;
			var clr:uint;
			var pos:int = 0;
			var len:int = baIn.length; 
			while (pos < len) {
				clr = baIn.readUnsignedInt();
				a = clr & 0xff000000;
				r = (clr >>> 16) & 0xff;
				g = (clr >>> 8) & 0xff;
				b = clr & 0xff;
				idx = (kr * r + kg * g + kb * b) >>> 0;
				clr = a | ct[idx];
				baOut.writeUnsignedInt(clr);
				pos += 4;
			}
			baOut.position = 0; //戻さないと駄目
			bmd.setPixels(bmd.rect, baOut);
			bmd.unlock();
		}
	}
}

import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}