/**
 * Copyright raduflash ( http://wonderfl.net/user/raduflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mDaV
 */

// forked from iong's flash calendar
/*
    flash calendar
    2010.04.10 google.comのcrossdomainが効かない...
               とりあえず祝日の取得を外しています
    2010.05.31 バグ修正（小の月）
*/
package{

    import flash.display.Sprite;

    public class calFla extends Sprite
    {
        import com.adobe.webapis.*;
        import com.adobe.serialization.json.JSON;
        import flash.text.TextField;
        import flash.events.Event;
        import flash.events.MouseEvent;
        import flash.net.URLRequest;
        import flash.net.URLLoader;
        import flash.xml.*;
        import flash.system.Security;

        private var aryHoliday:Array = new Array();
        private var ghUrl:URLRequest;
        private var ghLoader:URLLoader;

        private var boxR:Sprite      = new Sprite();
        private var intBoxSize:uint  = 40;
        private var intBoxSpan:uint  = 1;
        private var aryBox:Array     = new Array();
        private var aryMoveBox:Array = new Array();

        private var aryW:Array  = new Array("sun","mon","tue","wed","thu","fri","sat");
        private var aryLD:Array = new Array(31,28,31,30,31,30,31,31,30,31,30,31);

        private var calN:Date   = new Date();
        private var nY:Number   = calN.getFullYear();
        private var nM:Number   = calN.getMonth();
        private var nD:Number   = calN.getDate();

        private var calM:Date   = new Date();
        private var mY:Number   = calM.getFullYear();
        private var mM:Number   = calM.getMonth();
        private var mD:Number   = calM.getDate();
        private var cD:Number   = 0;
        private var cW:Number   = 0;
        private var intW:uint   = 0;
        private var intR:uint   = 0;
        private var intC:uint   = 0;

        private var arwR:Sprite = new Sprite();
        private var arwL:Sprite = new Sprite();
        private var prvY:Number = 0;
        private var prvM:Number = 0;
        private var fwdY:Number = 0;
        private var fwdM:Number = 0;

        private var txtDispYM:TextField;

//        private var _trace:TextField;
        
        public function calFla()
        {
/*
            _trace= new TextField();
            _trace.width= 500;
            _trace.height=500;
            addChild(_trace);
*/            
            boxR.x = stage.stageWidth/2 - (intBoxSize*7 + intBoxSpan*6)/2;
            boxR.y = stage.stageHeight/2- intBoxSize*3;
            addChild(boxR);

            arwR = new makeArrow(true);
            arwL = new makeArrow(false);
            arwL.y += arwR.height + 5;

            addChild(arwR);
            addChild(arwL);

            txtDispYM = new TextField();
            txtDispYM.selectable= false;
            txtDispYM.x = stage.stageWidth/2;
            addChild(txtDispYM);

            makeBox();

            makeCal(nY, nM);
            arwR.addEventListener(MouseEvent.CLICK, clickFwd);
            arwL.addEventListener(MouseEvent.CLICK, clickPrv);
        }

        // make calender box
        private function makeBox():void
        {
            for(var i:int=1; i<=31; i++){
                var p:Sprite = new makeCalPiece(intBoxSize);
                p.name = "date"+i;
                TextField(p.getChildByName("txt")).text = i.toString();
                var objBox:Object = new moveS(p, 3, 0.1);
                aryBox[i]= new Object();
                aryBox[i]= objBox;
            }
        }

        // get holiday(google api)
        private function loadHoliday(_Y:Number):void
        {
            Security.loadPolicyFile('http://www.google.com/crossdomain.xml');
            var strURL:String = 'http://www.google.com/calendar/feeds/japanese@holiday.calendar.google.com/public/full'
                        + '?start-min='+_Y+'-01-01'
                        + '&start-max='+(_Y+1)+'-01-01'
                        + '&orderby=starttime'
                        + '&sortorder=a';
            ghUrl    = new URLRequest(strURL);
            ghLoader = new URLLoader(ghUrl);
            ghLoader.load(ghUrl);
            ghLoader.addEventListener(Event.COMPLETE, ghLoaded);
        }
        private function ghLoaded(event:Event):void
        {
            aryHoliday[mY]= new Array();

            var _retXML:XMLDocument= new XMLDocument();
            _retXML.ignoreWhite    = true;
            _retXML.parseXML(ghLoader.data);
            var objR:Object = _retXML.firstChild.childNodes;
            for(var i:int=0; i<objR.length; i++){
                if(objR[i].nodeName=="entry"){
                    var tmpYMD:Array = objR[i].childNodes[13].attributes.startTime.toString().split("-");
                    var tmpKey:uint  = 10000 + (Number(tmpYMD[1])-1)*100+ Number(tmpYMD[2]);
                    aryHoliday[mY][tmpKey]= objR[i].childNodes[4].firstChild.nodeValue
                }
            }
            disp();
        }

        // main action
        private function makeCal(_Y:Number, _M:Number):void
        {
            init(_Y, _M);
            txtDispYM.text = _Y+'/'+(_M+1);
/*
            if(!aryHoliday[_Y]) loadHoliday(_Y);
            else                    disp();
*/
            disp();
        }
        private function init(_Y:Number, _M:Number):void
        {
            calM = new Date();
            if(_Y!=mY){calM.setFullYear(_Y); mY= calM.getFullYear(); }
            if(_M!=mM){
                if(aryLD[_M]<nD) calM.setDate(aryLD[_M]);
                calM.setMonth(_M);
                mM= calM.getMonth();
            }

            // leap year
            if((mY%4==0 && mY%100!=0) || mY%400==0) aryLD[1]= 29;
            else                                    aryLD[1]= 28;

            cD = calM.setDate(1);
            cW = calM.getDay();

            for(var i:int=1; i<=31; i++){
                var target:Object = aryBox[i].sp;
                if(target.hasEventListener(Event.ENTER_FRAME))target.removeEventListener(Event.ENTER_FRAME, movePiece);
            }

            aryMoveBox = new Array();
            aryMoveBox.push("");
        }

        // display calender
        private function disp():void
        {
            prvY = mY;
            prvM = mM-1;
            if(prvM<0){
                prvM= 11;
                prvY--;
            }

            fwdY = mY;
            fwdM = mM+1;
            if(fwdM>11){
                fwdM= 0;
                fwdY++;
            }

            intW = cW;
            intR = 0;
            intC = 1;
            boxR.addEventListener(Event.ENTER_FRAME, dispPiece);
        }

        private function dispPiece(e:Event):void
        {
            var target:Sprite = aryBox[intC].sp;
            if(intC<=aryLD[mM]){
//                target.getChildByName("spH").visible = (intW == 0 || aryHoliday[mY][(10000+mM*100+intC)]) ? true: false;
                target.getChildByName("spH").visible = (intW == 0) ? true: false;
                target.getChildByName("spT").visible = (mY==nY && mM==nM && intC==nD) ? true: false;
                boxR.addChild(target);
                var tX:Number   = intBoxSize*intW + intBoxSpan*intW;
                var tY:Number   = intBoxSize*intR + intBoxSpan*intR;

                var objM:Object = new Object();
                objM = {
                     _obj: aryBox[intC]
                    ,tX: tX
                    ,tY: tY
                };
                aryMoveBox.push(objM);
                target.addEventListener(Event.ENTER_FRAME, movePiece);

                intW++;
                if(intW==7){ intW = 0; intR++; }

            }else{
                if(boxR.getChildByName("date"+intC)!=null){
                    boxR.removeChild(target);
                }
            }
            intC++;
            if(intC>31) e.target.removeEventListener(Event.ENTER_FRAME, dispPiece);
        }
        private function movePiece(e:Event):void
        {
            var i:uint        = Number(e.target.name.substr(4));
            var to:Object     = aryMoveBox[i]._obj;
            var tX:Number     = aryMoveBox[i].tX;
            var tY:Number     = aryMoveBox[i].tY;
            to.act(tX, tY);
            if(Math.abs(to.sp.x-tX)<=0.2 && Math.abs(to.sp.y-tY)<=0.2){
                to.sp.x = tX;
                to.sp.y = tY;
                to.sp.filters= null;
                to.sp.removeEventListener(Event.ENTER_FRAME, movePiece);
            }
        }

        private function clickFwd(e:MouseEvent):void
        {
            makeCal(fwdY, fwdM);
        }
        private function clickPrv(e:MouseEvent):void
        {
            makeCal(prvY, prvM);
        }

/*
        public function t(event:*):void {
            _trace.appendText(""+event);
        }
*/
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.text.TextField;
import flash.filters.BlurFilter;
class moveS
{
    public var sp:Sprite;
    private var intPlus:int;
    private var intDev:Number;
    private var _addX:Number;
    private var _addY:Number;
    private var dX:Number;
    private var dY:Number;
    private var tX:Number;
    private var tY:Number;
    private var addX:Number;
    private var addY:Number;

    public function moveS(_sp:Sprite, iA:Number, iB:Number):void
    {
        sp      = _sp;
        intPlus = iA;
        intDev  = iB;
    }
    public function act(ax:Number, ay:Number):Array
    {
        addX    = _addX*intPlus;
        addY    = _addY*intPlus;
        _addX   = tX;
        _addY   = tY;
        dX      = (ax - sp.x);
        dY      = (ay - sp.y);
        tX      = dX*intDev;
        tY      = dY*intDev;
        sp.x   += tX + addX;
        sp.y   += tY + addY;
        sp.filters = [new BlurFilter(Math.round(Math.abs(dX/2)), Math.abs(Math.round(dY/2)))];
        return new Array(dX, dY);
    }
}

class makeArrow extends Sprite
{
    private var txt:TextField;
    function makeArrow(flg:Boolean):void
    {
        txt = new TextField();
        txt.selectable = false;
        txt.text = (flg) ? "▲": "▼";
        txt.width  = 18;
        txt.height = 18;
        scaleX = scaleY = 2;
        addChild(txt);
    }
}

class makeCalPiece extends Sprite
{
    private var txtDate:TextField;
    private var clN:Number = 0xdddddd;
    private var clH:Number = 0xffe0e0;
    private var clT:Number = 0xf0f0f0;

    function makeCalPiece(size:uint):void
    {
        var sp:Sprite  = new Sprite();
        var spH:Sprite = new Sprite();
        var spT:Sprite = new Sprite();
        sp.name  = "sp";
        spH.name = "spH";
        spT.name = "spT";
        with(sp.graphics){
            beginFill(clN, 1);
            drawRoundRect(0,0,size,size,4);
            endFill();
        }
        with(spH.graphics){
            beginFill(clH, 1);
            drawRoundRect(0,0,size,size,4);
            endFill();
        }
        with(spT.graphics){
            beginFill(clT, 1);
            drawRoundRect(0,0,size,size,4);
            endFill();
        }
        txtDate = new TextField();
        txtDate.selectable= false;
        txtDate.name = "txt";

        addChild(sp);
        addChild(spH);
        addChild(spT);
        spH.visible = false;
        spT.visible = false;
        addChild(txtDate);
    }
}
