/**
 * Copyright masamunet ( http://wonderfl.net/user/masamunet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mCs2
 */

package  {
	
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * ソートテスト全体の進行を管理するクラス。
	 */
	public class FlashTest extends Sprite {
		private var _startData:String;
		private var _message:Message;
		private var _tween24Sort:Tween24Sort;
		
		/**
		 * constructor
		 */
		public function FlashTest() {
			const MARGIN:Number = 10;
			_message = new Message();
			_message.width = stage.stageWidth - (MARGIN * 2);
			_message.height = stage.stageHeight - (MARGIN * 2);
			_message.x = _message.y = MARGIN;
			addChild(_message);
			
			var randomData:Vector.<Number> = RandomData.create(10);
			_startData = _format(randomData);
			_tween24Sort = new Tween24Sort(randomData);
			_start();
		}
		
		/**
		 * テスト開始
		 */
		private function _start():void
		{
			_tween24Sort.addEventListener(Event.COMPLETE, _complete);
			addEventListener(Event.ENTER_FRAME, _proccessing);
			_message.text = _startData + "\rソートスタート";
			_tween24Sort.start();
		}
		
		/**
		 * テスト中実行
		 */
		private function _proccessing(e:Event):void
		{
			var message:Array = [_startData
								 , ""
								 , "ソート中" + Proccessing.enter()
								 , ""
								 , _format(_tween24Sort.data)
								 ];

			_message.text = message.join("\r");
		}
		
		/**
		 * テスト完了
		 */
		private function _complete(e:Event):void
		{
			_tween24Sort.removeEventListener(Event.COMPLETE, _complete);
			removeEventListener(Event.ENTER_FRAME, _proccessing);
			var lastData:Number = _tween24Sort.data[_tween24Sort.data.length - 1];
			_message.text += "\r" + String(lastData) + "\rソート終了";
		}
		
		/**
		 * データーを表示しやすいように整形
		 */
		private function _format(v:Vector.<Number>):String
		{
			return v.join("\r");
		}
	}
	
}
import a24.tween.Tween24;
import flash.events.EventDispatcher;
import flash.events.Event;

/**
 * ソートアルゴリズムを使わず、Tween24のみで正の数値をソートするクラスです。
 */
class Tween24Sort extends EventDispatcher
{
	private static const _TWEEN24_GROUP_NAME:String = "sortGroupId";
	private var _target:Vector.<Number>;
	private var _data:Vector.<Number>;
	
	/**
	 * constructor
	 */
	function Tween24Sort(target:Vector.<Number>):void
	{
		_target = target;
	}
	
	/**
	 * ソートを開始します。
	 */
	public function start():void
	{
		_data = new Vector.<Number>();
		for each(var n:Number in _target){
			_addData(n);
		}
		/*
		group化されたTween24.serialをparallelで実行
		*/
		Tween24.getGroupTween(_TWEEN24_GROUP_NAME).onComplete(function(){
			/*
			すべて処理が終わればEvent.COMPLETEをdispatchする。
			*/
			dispatchEvent(new Event(Event.COMPLETE));
			Tween24.disposeGroupTweens(_TWEEN24_GROUP_NAME);
		}).play();
	}
	
	/**
	 * ソートアイテムをTween24.serialでまとめる
	 */
	private function _addData(n:Number):void
	{
		if(isNaN(n)){
			return;
		}
		if(n < 0){
			return;
		}
		/*
		n秒待ってpush
		*/
		Tween24.serial(
			Tween24.setTimeScale(0.1),
			Tween24.wait(n),
			Tween24.func(function(){
				_data.push(n);
			})
		).group(_TWEEN24_GROUP_NAME);
	}
	
	/**
	 * ソート中のリアルタイムデーターです。
	 */
	public function get data():Vector.<Number>
	{
		return _data.concat();
	}
}




/**
 * ランダムデーターを作るクラスです。
 */
class RandomData
{
    public static function create(length:int):Vector.<Number>
    {
        var ret:Vector.<Number> = new Vector.<Number>;
        for(var i:int = 0; i < length; i++){
            ret[i] = Math.random() * length;
        }
        return ret;
    }
}

import flash.text.TextField;
import flash.text.TextFormat;

/**
 * メッセージ表示用クラス
 */
class Message extends TextField
{
	function Message():void
	{
		super();
		var tf:TextFormat = new TextFormat("_ゴシック", 12);
		tf.leading = 2;
		defaultTextFormat = tf;
		wordWrap = true;
		multiline = true;
	}
}

/**
 * プロセス実行中の細かい処理を行うユーティリティ
 */
class Proccessing
{
	private static const _MARK:String = '・';
	private static const _MAX_LENGTH:int = 10;
	private static var _process:String = "";
	
	public static function enter():String
	{
		if(_process.length > _MAX_LENGTH){
			_process = _MARK;
		}else{
			_process += _MARK;
		}
		return _process;
	}
}