/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mBtV
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.filters.ColorMatrixFilter;
    
    [SWF(width="465",height="465",frameRate="60")]
    
    public class FlashTest extends Sprite {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        private var sp:Sprite;
        private var canvas:BitmapData;
        private var backcanvas:BitmapData;
        
        private var circleTop:CircleObject;
        
        public function FlashTest() {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            sp = new Sprite();
            
            backcanvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild(new Bitmap(backcanvas));
            
            canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild(new Bitmap(canvas));
            
            InitCircle();
            
            addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, MouseClickHandler);
        }
        
        private function InitCircle():void
        {
            circleTop = CircleObject.CreateCircle();
            circleTop.x = Math.random() * WIDTH;
            circleTop.y = Math.random() * HEIGHT;
            
            var nowcircle:CircleObject = circleTop;
            for(var i:int = 0; i < 20; i++)
            {
                var childcircle:CircleObject = CircleObject.CreateCircle();
                childcircle.parent = nowcircle;
                nowcircle.AddChild(childcircle);
                nowcircle = childcircle;
            }
        }
        
        private function EnterFrameHandler(e:Event):void
        {
            sp.graphics.clear();
            circleTop.Move();
            circleTop.Draw(sp, true);
            
            var color:ColorTransform = new ColorTransform(1, 1, 1, 0.01);
            canvas.applyFilter(canvas, canvas.rect, new Point(), new ColorMatrixFilter([
            1,0,0,0,0,
            0,1,0,0,0,
            0,0,1,0,0,
            0,0,0,0.9999,0
            ]));
            canvas.draw(sp, null);
            
            backcanvas.draw(canvas, null, null, "add");
            backcanvas.applyFilter(backcanvas, backcanvas.rect, new Point(), new BlurFilter());
        }
        
        private function MouseClickHandler(e:MouseEvent):void
        {
            canvas.fillRect(canvas.rect, 0);
            sp.graphics.clear();
            
            InitCircle();
        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import frocessing.color.ColorHSV;

class CircleObject
{
    private var _childList:/*CircleObject*/Array;
    private var _parent:CircleObject;
    private var _offsetAngle:Number;
    private var _x:Number;
    private var _y:Number;
    private var _prevX:Number;
    private var _prevY:Number;
    private var _radius:Number;
    private var _angle:Number;
    
    private var _rotateSpeed:Number;
    private var _color:uint;
    
    public function CircleObject()
    {
        _childList = null;
        _parent = null;
        _x = 0;
        _y = 0;
        _radius = 0;
        _angle = 0;
        _offsetAngle = 0;
        _rotateSpeed = 0;
    }
    
    public function AddChild(child:CircleObject):void
    {
        if(_childList == null) _childList = [];
        _childList.push(child);
    }
    
    public function get parent():CircleObject{return _parent;}
    public function set parent(obj:CircleObject):void
    {
        _parent = obj;
        var rad:Number = (_parent.angle + _offsetAngle)*Math.PI/180;
        _x = _parent.x + Math.cos(rad) * _parent.radius;
        _y = _parent.y + Math.sin(rad) * _parent.radius;
    }
    
    public function get offsetAngle():Number {return _offsetAngle;}
    public function set offsetAngle(val:Number):void {
        _offsetAngle = val;
    }
    public function get x():Number {
        return _x;
    }
    public function set x(val:Number):void {
        _x = val;
    }
    public function get y():Number {
        return _y;
    }
    public function set y(val:Number):void {
        _y = val;
    }
    public function get radius():Number {
        return _radius;
    }
    public function set radius(val:Number):void {
        _radius = val;
    }
    public function get angle():Number {
        return _angle;
    }
    public function set angle(val:Number):void {
        _angle = val;
    }
    public function get rotatespeed():Number {
        return _rotateSpeed;
    }
    public function set rotatespeed(val:Number):void {
        _rotateSpeed = val;
    }
    public function get color():uint {
        return _color;
    }
    public function set color(val:uint):void {
        _color = val;
    }
    
    public function Move():void {
        _prevX = _x;
        _prevY = _y;
        
        if(_parent != null)
        {
            var rad:Number = (_parent.angle + _offsetAngle)*Math.PI/180;
            _x = _parent.x + Math.cos(rad) * _parent.radius;
            _y = _parent.y + Math.sin(rad) * _parent.radius;
        }
        
        _angle = (_angle + _rotateSpeed) % 460;
        if(_childList != null)
        {
            var childnum:int = _childList.length;
            for(var i:int = 0; i < childnum; i++)
            _childList[i].Move();
        }
    }
    
    public function Draw(canvas:Sprite, top:Boolean):void
    {
        var g:Graphics = canvas.graphics;
        
        if(!top)
        {
            var hsv:ColorHSV = new ColorHSV();
            hsv.h = _parent.angle + _offsetAngle;
            g.lineStyle(1, hsv.value, 0.3);
            g.moveTo(_prevX, _prevY);
            g.lineTo(_x, _y);
        }
        
        if(_childList != null)
        {
            var childnum:int = _childList.length;
            for(var i:int=0; i<childnum; i++)
            _childList[i].Draw(canvas, false);
        }
    }
    
    public static function CreateCircle():CircleObject
    {
        var obj:CircleObject = new CircleObject();
        obj.radius = Math.random() * 200 + 10;
        obj.angle = Math.random() * 360;
        obj.offsetAngle = Math.random() * 360;
        obj.rotatespeed = Math.random() * 2 - 1;
        
        var color:ColorHSV = new ColorHSV();
        color.h = Math.random()*360;
        color.s = 1;
        obj.color = color.value;
        return obj;
    }
















    
    



    
}
