/**
 * Copyright milino ( http://wonderfl.net/user/milino )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mBli
 */

package  
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    
    /**
     * ...
     * @author Xing
     */
    public class Main extends Sprite 
    {
        
        private var _cacheX:int;
        private var _cacheY:int;
        private var _isDown:Boolean;
        private var _scene:Sprite;
        
        public function Main() 
        {
            _scene = new Sprite();
            this.addChild(_scene);
            _scene.filters = [new GlowFilter(0x00CCFF, 1, 10, 10, 2, 1, false, false)];
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
            this.addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        private function downHandler(e:MouseEvent):void
        {
            _cacheX = mouseX;
            _cacheY = mouseY;
            _isDown = true;
        }
        private function upHandler(e:MouseEvent):void
        {
            _isDown = false;
        }
        private function enterFrame(e:Event):void
        {
            for each (var l:Line in Line.sets) 
            {
                l.update();
            }
            update();
        }
        private function update():void
        {
            if (!_isDown) return;
            var line:Line = new Line(_cacheX, _cacheY, mouseX, mouseY);
            _scene.addChild(line);
            _cacheX = mouseX;
            _cacheY = mouseY;
        }
        
    }

}
import flash.display.Sprite;
class Line extends Sprite
{
    static public var sets:Array = [];
    
    public var sX:int;
    public var sY:int;
    public var eX:int;
    public var eY:int;
    public var linesize:Number;
    public function Line($sX:int, $sY:int, $eX:int, $eY:int, $linesize:Number = 8)
    {
        sets.push(this);
        sX = $sX;
        sY = $sY;
        eX = $eX;
        eY = $eY;
        linesize = $linesize;
        draw();
    }
    private function draw():void
    {
        graphics.clear();
        graphics.lineStyle(linesize, 0xFFFFFF);
        graphics.moveTo(sX, sY);
        graphics.lineTo(eX, eY);
    }
    public function update():void
    {
        draw();
        linesize -= 1;
        if (linesize < 1)
        {
            clear();
        }
    }
    private function clear()
    {
        graphics.clear();
        for (var i:String in sets) 
        {
            var l:Line = sets[i] as Line;
            if (l == this)
            {
                sets.splice(i, 1);
                parent.removeChild(this);
            }
        }
    }
}