/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mBKD
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=285
    public class Euler285 extends Sprite {
        private var _tf : TextField;
  
        public function Euler285() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            tr(solve(10));
            tr(solve(100000));
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        // 難しそうに書いてあるけど、要は(1,1)~(k+1,k+1)の正方形のなかでの
        // 原点中心の半径k-0.5~k+0.5の環の割合を求めてkをかけて足していくだけ。
        private function solve(N : uint) : Number
        {
        		var ret : Number = 0;
        		for(var k : uint = 2;k <= N;k++){
        			ret += (S(k+0.5) - S(k-0.5))/k;
        		}
    			ret += S(1.5)/1;
    			return ret;
        }
        
        private function S(k : Number) : Number
        {
        		return k*k*(Math.PI/4-Math.asin(1/k))-(Math.sqrt(k*k-1)-1);
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}
