/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mAng
 */

// image by Michal Hotovec on Dribbble: http://dribbble.com/shots/255285-Battery

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;    
    import flash.geom.Point;
    import flash.geom.Rectangle;    
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.system.Security;
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import net.hires.debug.Stats;    
    
    [SWF(frameRate = '24', width=465, height=456, backgroundColor='0x000000')]
    public class Main extends Sprite {
        private var img:String = "http://dribbble.com/system/users/5070/screenshots/255285/battery.png";             
        private var canvas:Bitmap;
        private var canvasFrames:Array = new Array(); 
        private var sheetColumns:int;    
        private var tileWidth:int = 50;
        private var tileHeight:int = 100;        
        private var totalFrames:int = 24;
        private var currentFrame:int = 0;
        private var framePointer:Shape;
        private var slider:HSlider;
        private var label:Label;
        
        public function Main() {
            addChild(new Stats());
                         
            // load image from dribbble
            Security.loadPolicyFile("http://dribbble.com/crossdomain.xml");
        
            var loader:Loader=new Loader();
            loader.load(new URLRequest(img));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, generateFrames);
        }
        
        //________________________________________________________ GENERATE FRAMES FROM SHEET
        private function generateFrames(e:Event):void
        {            
            var imgBD:BitmapData = e.target.content.bitmapData;
                        
            
            // original sheet
            var holder:Sprite = new Sprite();
            holder.x = 70;            
            holder.alpha = 0.2;
            addChild(holder);            
            
            var sheet:Bitmap = new Bitmap(imgBD);            
            holder.addChild(sheet);
            holder.width = 395;
            holder.scaleY = holder.scaleX;
                
            framePointer = new Shape();            
            framePointer.graphics.lineStyle(1, 0xffffff);
            framePointer.graphics.drawRect(0, 0, tileWidth, tileHeight);
            holder.addChild(framePointer);         
            
            
            // frames...
            sheetColumns = int(imgBD.width / tileWidth);
            var pt:Point = new Point(0, 0);
            var rect:Rectangle = new Rectangle(0, 0, tileWidth, tileHeight);           
            
             for (var i:int = 0; i < totalFrames; i++) {
                rect.x = int(i%sheetColumns) * tileWidth;
                rect.y = int(i/sheetColumns) * tileHeight;
                canvasFrames.push(new BitmapData(tileWidth, tileHeight));
                canvasFrames[i].copyPixels(imgBD, rect, pt);
            }
            
            
            // add canvas to stage
            canvas = new Bitmap();
            canvas.smoothing = true;
            canvas.bitmapData = new BitmapData(tileWidth, tileHeight);            
            canvas.x = 200;
            canvas.y = 320;
            addChild(canvas);    
            
            slider = new HSlider(this, 180, 440, sliderChange);
            slider.value = stage.frameRate/0.6;
            
            
            label = new Label(this, 120, 435, "frameRate: ");
            
            // update   
            addEventListener(Event.ENTER_FRAME, update);  
        }
        
        private function sliderChange(e:Event):void
        {
            trace("slider value: " + slider.value);
            stage.frameRate = int(slider.value * 0.6);
        }
        
        //________________________________________________________ UPDATE
        private function update(e:Event):void
        {
            currentFrame ++;
            if (currentFrame >= totalFrames) currentFrame = 0;
            canvas.bitmapData = canvasFrames[currentFrame]; 
            
            framePointer.x = int(currentFrame % sheetColumns) * tileWidth;
            framePointer.y = int(currentFrame/sheetColumns) * tileHeight;
        } 
    }
}