/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m9GQ
 */

// forked from nextyukke's ブロック崩し
package {
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    //sion----------------------------------------------------------
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONEvent;
    import org.si.sion.utils.Scale;
    import org.si.sion.utils.SiONPresetVoice;
    import org.si.sound.Arpeggiator;    
    //sion----------------------------------------------------------
    public class FlashTest extends Sprite {
        private const BAR_LENGTH:Number = 200;
        private const BAR_OFFSET:Number = 32;
        private const BALL_RADIUS:Number = 20;
        private const BALL_SPEED:Number = 20;
        
        private var sp:Sprite;
        private var bar_:Sprite;
        private var ballVector_:Vector3D;
        private var ballPoint_:Point;
        //sion----------------------------------------------------------
        private var arpeggiator:Arpeggiator;
        public var driver:SiONDriver = new SiONDriver();
        private var rythmLoop:SiONData;
        private var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        
        private var px:Number=0;
        private var py:Number=0;
        //sion----------------------------------------------------------
        
        public function FlashTest() {
            // write as3 code here..
            stage.frameRate = 60;
            
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
            //sion----------------------------------------------------------
            initSound();
            soundStart();
            //sion----------------------------------------------------------
        }
        
        private function init(e:Event=null):void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            ballPoint_ = new Point(stage.stageWidth / 2, stage.stageHeight - 32);
            ballVector_ = new Vector3D(0, -BALL_SPEED, 0);
            
            bar_ = new Sprite();
            bar_.mouseEnabled = false;
            bar_.graphics.beginFill(0x3f3fff);
            bar_.graphics.drawRect(-BAR_LENGTH / 2, 0, BAR_LENGTH, 4);
            bar_.graphics.endFill();
            bar_.x = stage.stageWidth / 2;
            bar_.y = stage.stageHeight - BAR_OFFSET;
            addChild(bar_);
            
            sp = new Sprite();
            sp.mouseEnabled = false;
            sp.graphics.beginFill(0xff3f3f);
            sp.graphics.drawCircle(0, 0, BALL_RADIUS);
            sp.graphics.endFill();
            sp.x = ballPoint_.x;
            sp.y = bar_.y - BALL_RADIUS;
            addChild(sp);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function checkHittingSide(type:String, x:Number, y:Number, radius:Number):Boolean {
            if (type == SideType.LEFT && x < radius) {
                return true;
            }
            else if (type == SideType.RIGHT && x > stage.stageWidth - radius) {
                return true;
            }
            else if (type == SideType.TOP && y < radius) {
                return true;
            }
            else if (type == SideType.BOTTOM && y > stage.stageHeight - radius) {
                return true;
            }

            return false;
        }
        
        private function checkHittingBar(x:Number, y:Number, radius:Number, barX:Number, barY:Number, length:Number):Boolean {
            if (barY < (y + radius)) {
                var lenD2:Number = length / 2;
                if (barX - lenD2 < x && x < barX + lenD2) {
                    return true;
                }
            }

            return false;
        }


        private function onMouseMove(e:MouseEvent):void {
            bar_.x = e.stageX;
            bar_.y = e.stageY;
        }

        private function onEnterFrame(e:Event):void {
            var preX:Number = sp.x + ballVector_.x;
            var preY:Number = sp.y + ballVector_.y;
            
            if (checkHittingSide(SideType.LEFT, preX, preY, BALL_RADIUS)) {
                ballVector_.x = Math.abs(ballVector_.x);
            }
            else if (checkHittingSide(SideType.RIGHT, preX, preY, BALL_RADIUS)) {
                ballVector_.x = -Math.abs(ballVector_.x);
            }
            else if (checkHittingSide(SideType.TOP, preX, preY, BALL_RADIUS)) {
                ballVector_.y = BALL_SPEED;
            }
            else if (checkHittingSide(SideType.BOTTOM, preX, preY, BALL_RADIUS)) {
                ballVector_.y = -BALL_SPEED;
            }
            else if (ballVector_.y > 0 && checkHittingBar(preX, preY, BALL_RADIUS, bar_.x, bar_.y, BAR_LENGTH)){
                var rate:Number = (preX - bar_.x) / (BAR_LENGTH / 2);
                ballVector_.x  = rate *8;
                ballVector_.y = -BALL_SPEED;
            }
            else {
                sp.x = preX;
                sp.y = preY;
            }
        }
        //sion----------------------------------------------------------
        private function initSound():void {
            var mml:String = "t132;";
            rythmLoop = driver.compile(mml);
            rythmLoop.setVoice(0, presetVoice["valsound.percus1"]);
            //rythmLoop.setVoice(0, presetVoice["valsound.percus13"]);
            
            arpeggiator = new Arpeggiator(new Scale("o1Ajap"), 1, [0,1,2,5,4,3]);
            //arpeggiator.voice = presetVoice["valsound.piano8"];
            //arpeggiator.voice = presetVoice["valsound.wind1"];
            //arpeggiator.voice = presetVoice["valsound.guitar2"];
            //arpeggiator.voice = presetVoice["valsound.percus25"];
            //arpeggiator.voice = presetVoice["valsound.percus1"];
            //arpeggiator.voice = presetVoice["valsound.lead25"];
            arpeggiator.voice = presetVoice["valsound.percus13"];
            arpeggiator.quantize = 4;
            arpeggiator.volume = 0.3;
            arpeggiator.noteQuantize = 8;
            
            
            driver.addEventListener(SiONEvent.STREAM, onStreamHandler);
            driver.play(rythmLoop);
            
            //bug??
            //arpeggiator.noteOn();
            //arpeggiator.noteOff();
            arpeggiator.pattern = [0,1,2,5,4,3];
        }
        
        
        private function onStreamHandler(e:SiONEvent):void {
            // update arpeggiator pitch and length
            setPxPy();
            arpeggiator.scaleIndex = px * 12;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
        }
        
        public function soundStart():void {
            setPxPy();
            arpeggiator.scaleIndex = px*12;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
            // start arpeggio
            arpeggiator.play();
        }
        
        private function setPxPy():void {
            px = sp.x / 100;
            py = sp.y / 465;
            if(px<0)px=0;
            if(px>0.9)px=0.9;
            if(py<0)py=0;
            if(py>0.9)py=0.9;
        }
        //sion----------------------------------------------------------
    }

}

import flash.display.Sprite;
internal class Ball extends Sprite {
}

internal class SideType {
    public static const LEFT:String = "LEFT";
    public static const RIGHT:String = "RIGHT";
    public static const TOP:String = "TOP";
    public static const BOTTOM:String = "BOTTOM";
}
