/**
 * Copyright mex_ny ( http://wonderfl.net/user/mex_ny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m7s9
 */

package 
{
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.Keyboard;
	import flash.filters.BlurFilter;	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.ITween;


	public class Main extends Sprite 
	{
		private const ALPHABET_LIST:Array = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"];
		private const KEYCODE_A_NUMBER:uint = 65;
		private var _keycodeObj:Object = new Object();
		private var _tf:TextField;
		private var _stageWidth:Number , _stageHeight:Number;
		private var _cb:CharBitmap;
		private var _charDots:Vector.<Dot>;
		private var _charDotsLength:uint;
		private var _charSps:Array = new Array();
		
		public function Main():void 
		{
			if ( stage ) init();
			else addEventListener(Event.ADDED_TO_STAGE, init );
		}
		
		private function init( e:Event = null ):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
		
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.BEST;
			_stageWidth = stage.stageWidth;
			_stageHeight = stage.stageHeight;
			
			addBackground();
			createKeycodeObj();
			addTextField();
			stage.addEventListener( KeyboardEvent.KEY_UP , keyUpHandler );
		}
		
		private function addBackground():void
		{
			var g:Graphics , bg:Sprite;
			addChild( bg = new Sprite() );
			g = bg.graphics;
			g.beginFill( 0xffffff );
			g.drawRect( 0 , 0 , _stageWidth , _stageHeight );
			g.endFill();
		}
		
		private function createKeycodeObj():void
		{
			var i:uint , len:uint;
			len = ALPHABET_LIST.length;
			
			for ( i = 0; i < len; i++ )
			{
				_keycodeObj[( KEYCODE_A_NUMBER + i ).toString()] = ALPHABET_LIST[i];
			}
		}
		
		private function addTextField():void
		{
			addChild( _tf = new TextField() );
		}

		private function keyUpHandler( $e:KeyboardEvent ):void
		{
			var char:String, sp:Sprite;

			char = _keycodeObj[ $e.keyCode ];
			if ( char != null )
			{
				changeFofmat( char );
				addCharBitmap( char );
				sp = resolution();
				BetweenAS3.tween( sp , { _blurFilter: { blurX: 16, blurY: 16 } } , { _blurFilter: { blurX: 0, blurY: 0 } } , 1 , Cubic.easeOut ).play();
				removeCharBitmap();
				_tf.text = "";
				loop( sp );
			}
		}
		
		private function changeFofmat( char:String ):void
		{
			var format:TextFormat;
			_tf.text = char;
			format = _tf.getTextFormat();
			format.size = 80;
			format.color = Math.random() *  0xFFFFFF;
			_tf.setTextFormat( format );
			_tf.width = _tf.textWidth + 4;
			_tf.height = _tf.textHeight + 4;
		}
		
		private function addCharBitmap( char:String ):void
		{
			addChild( _cb = new CharBitmap( _tf ) );
		}
		
		private function resolution():Sprite
		{
			var x:uint , y:uint , tbWidth:uint , tbHeight:uint , pixel:uint , bmd:BitmapData , dot:Dot , charSp:Sprite , charDots:Vector.<Dot>;;

			tbWidth = _cb.width;
			tbHeight = _cb.height;
			bmd = _cb.bitmap.bitmapData;
			charDots = new Vector.<Dot>();
			
			addChild( charSp = new Sprite() );
			charSp.x = Math.random() * _stageWidth;
			charSp.y = Math.random() * _stageHeight;
			
			for ( y = 0; y < tbHeight; y++)
			{
				for ( x = 0; x < tbWidth; x++ )
				{
					pixel = bmd.getPixel( x , y );

					if ( pixel > 0 )
					{
						charSp.addChild( dot = new Dot( x , y , pixel ) );
						charDots.push( dot );
					}
				}
			}
			_charSps.push( { sp:charSp , dots:charDots } );			

			return charSp;
		}
		
		private function removeCharBitmap():void
		{
			_cb.remove();
		}
		private function loop( sp:Sprite ):void
		{
			var dataObj:Object , sp:Sprite , dotsList:Vector.<Dot> , len:uint , i:uint , dot:Dot , check:Boolean , count:uint;
			dataObj = _charSps.shift();
			sp = dataObj["sp"];
			dotsList = dataObj["dots"];
			sp.addEventListener( Event.ENTER_FRAME ,
				function():void
				{ 
					len = dotsList.length;
					for ( i = 0; i < len; i++ )
					{
						if ( dotsList[i] != null )
						{
							dot = dotsList[i];
							check = dot.update();
						
							if ( !check )
							{
								count += 1;
								dot.remove();
								dotsList[i] = dot = null;

								if ( count == ( dotsList.length - 1 ) )
								{
									removeChild( sp );
									removeEventListener( Event.ENTER_FRAME , loop );
								}
							}
						}
					}
				} 
			);
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
class CharBitmap extends Sprite
{
	private var _bitmap:Bitmap;
	private var _tf:TextField;
	
	public function CharBitmap( tf:TextField ):void 
	{
		_tf = tf;
		textFieldToBitmap( tf );
	}
	
	public function remove():void
	{
		if ( parent != null ) parent.removeChild( this );
		if ( _bitmap != null )
		{
			removeChild( _bitmap );
			_bitmap.bitmapData.dispose();
			_bitmap = null;
		}
	}
	
	private function textFieldToBitmap( tf:TextField ):void
	{
		var bmd:BitmapData;

		bmd = new BitmapData( tf.textWidth , tf.height , true , 0xffffff );
		bmd.draw( tf );
		_bitmap = new Bitmap( bmd );
		addChild( _bitmap );
		//if ( tf.parent != null ) tf.parent.removeChild( tf );
		//tf = null;
	}
	
	public function get bitmap():Bitmap { return _bitmap; }
}


import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Graphics;
class Dot extends Sprite
{
	private var _color:uint;
	private var _vx:Number;
	private var _vy:Number;
	private var _r:Number;
	private var _a:int = 0;
	
	public function Dot( x:uint , y:uint , color:uint ):void 
	{
		this.x = x;
		this.y = y;
		_color = color;
		drawCircre();
	}

	private function drawCircre():void
	{
		var g:Graphics , rad:Number;
		g = this.graphics;

		g.beginFill( _color );
		g.drawCircle( 0 , 0 , 1 );
		g.endFill();

		//rad = ( Math.random() * 90 * Math.PI / 180 ) + 180;
		rad = ( Math.random() * 70 * Math.PI / 180 ) + 180;
		//rad = ( Math.random() * 360 * Math.PI / 180 ) + 180;
       	_r = Math.random() * 5;
       	_vx = Math.cos(rad) * _r;
       	_vy = Math.sin(rad) * _r;
	}
	
	public function update():Boolean
	{
		x += _vx;
		y += _vy;
		_vx *= 1;
		_vy *= 1;

		alpha = 0.9 - ( _a / 30 );
		_a++;

		if( alpha < 0 )
			return false;
		else
			return true;
	}
	
	public function remove():void
	{
		parent.removeChild( this );
		graphics.clear();
	}
}