/**
 * Copyright leocavalcante ( http://wonderfl.net/user/leocavalcante )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m70b
 */

package 
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	public class Main extends Sprite
	{
		private var data:Data;
		private var paperList:List;
		private var tieList:List;
		private var paperImage:Image;
		private var tieImage:Image;
		
		public function Main()
		{
			data = new Data();
			
			paperList = new List();
			paperList.dataProvider = data.getAllPaperThumbs();
			paperList.addEventListener(MouseEvent.CLICK, paperThumbClick);
			addChild(paperList);
			
			tieList = new List();
			tieList.dataProvider = data.getAllTieThumbs();
			tieList.x = 75;
			tieList.addEventListener(MouseEvent.CLICK, tieThumbClick);
			addChild(tieList);
			
			paperImage = new Image();
			paperImage.x = 150;
			addChild(paperImage);
			
			tieImage = new Image();
			tieImage.x = 150;
			addChild(tieImage);
			
			init();
		}
		
		private function init():void
		{
			paperImage.source = data.getPaperByID(0);
			tieImage.source = data.getTieByID(0);
		}
		
		private function paperThumbClick(event:MouseEvent):void 
		{
			paperImage.source = data.getPaperByID(event.target.id);
		}
		
		private function tieThumbClick(event:MouseEvent):void 
		{
			tieImage.source = data.getTieByID(event.target.id);
		}
	}
}

import flash.display.DisplayObject;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.net.URLRequest;
import flash.utils.setTimeout;
import flash.utils.Timer;

class Data
{
	public var papers:Array = ["branco.png", "preto.png", "vermelho.png", "verde.png", "laranja.png"];
	public var ties:Array = ["branca.png", "preta.png", "vermelha.png", "verde.png", "laranja.png"];
	
	public var paperBaseURL:String = "http://veralubemcasados.com.br/media/imagens/bem-casados/papel-grande/";
	public var paperThumbBaseURL:String = "http://veralubemcasados.com.br/media/imagens/bem-casados/papel/";
	
	public var tieBaseURL:String = "http://veralubemcasados.com.br/media/imagens/bem-casados/fita-grande/";
	public var tieThumbBaseURL:String = "http://veralubemcasados.com.br/media/imagens/bem-casados/fita/";
	
	public function getAllPaperThumbs():Array
	{
		var results:Array = [];
		for each (var paper:String in papers)
		{
			results.push(paperThumbBaseURL + paper);
		}
		return results;
	}
	
	public function getAllTieThumbs():Array
	{
		var results:Array = [];
		for each (var tie:String in ties)
		{
			results.push(tieThumbBaseURL + tie);
		}
		return results;
	}
	
	public function getPaperByID(id:int):String
	{
		return paperBaseURL + papers[id];
	}
	
	public function getTieByID(id:int):String
	{
		return tieBaseURL + ties[id];
	}
}

class List extends Sprite
{
	private var data:Array;
	
	public function push():void
	{
		for each (var item:String in data)
		{
			var thumb:Thumb = new Thumb(item);
			thumb.id = data.indexOf(item);
			thumb.y = 25 * thumb.id;
			addChild(thumb);
			
			Tween.fromTo(thumb, { alpha:0 }, { alpha:1}, 10, thumb.id * 100);
		}
	}
	
	public function set dataProvider(value:Array):void
	{
		data = value;
		push();
	}
}

class Thumb extends Sprite
{
	public var id:int;
	private var loader:Loader;
	
	public function Thumb(url:String)
	{
		mouseChildren = false;
		buttonMode = true;
		
		loader = new Loader();
		loader.load(new URLRequest(url));
		addChild(loader);
	}
}

class Image extends Sprite
{
	private var image:String;
	private var loader:Loader;
	
	public function Image()
	{
		loader = new Loader();
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete);
		addChild(loader);
	}
	
	private function load():void
	{
		loader.load(new URLRequest(image));
	}
	
	private function complete(event:Event):void 
	{
		Tween.fromTo(loader, { alpha:0 }, { alpha:1 }, 10, 0);
	}
	
	public function set source(value:String):void
	{
		image = value;
		Tween.fromTo(loader, { alpha:1 }, { alpha:0 }, 10, 0, load);
	}
}

class Tween
{
	public static function fromTo(target:DisplayObject, from:Object, to:Object, duration:Number, delay:Number = 0, onComplete:Function = null):void
	{
		var tween:Tween = new Tween();
		tween.target = target;
		tween.from = from;
		tween.to = to;
		tween.duration = duration;
		tween.delay = delay;
		tween.onComplete = onComplete;
		tween.tween();
	}
	
	public var target:DisplayObject;
	public var from:Object;
	public var to:Object;
	public var duration:Number;
	public var delay:Number;
	public var onComplete:Function;
	
	private var timer:Timer;
	private var isTweening:Boolean;
	
	public function tween():void
	{
		for (var p:String in from) {
			target[p] = from[p];
		}
		
		isTweening = false;
		
		timer = new Timer(1);
		timer.addEventListener(TimerEvent.TIMER, timerTimer);
		setTimeout(timer.start, delay);
	}
	
	private function timerTimer(event:TimerEvent):void
	{
		isTweening = true;
		
		for (var p:String in to) {
			target[p] += (to[p] - target[p]) / duration;
			if (target[p] == to[p]) {
				isTweening = false;
				timer.stop();
				if (onComplete != null) onComplete();
			}
		}
	}
}