/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m6el
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.shaders.*;
	import org.papervision3d.materials.*;
	//import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.render.*;
	import org.papervision3d.scenes.*;
	import org.papervision3d.view.*;
	import org.papervision3d.lights.*;

	public class Main extends Sprite {
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine;
		private var obj:DisplayObject3D;
		private var light:PointLight3D;
		private var offset:Number = 0;

		public function Main() {
			Wonderfl.disable_capture();
                        Wonderfl.capture_delay(3);
			//bg
			graphics.beginFill(0x000000);
			graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			scene = new Scene3D();
			//camera
			camera = new Camera3D();
			camera.x = camera.y = 0;
			camera.z = -1000;
			camera.focus = 100;
			camera.zoom = 10;
			//vieport
			viewport = new Viewport3D(stage.stageWidth,stage.stageHeight);
			addChild(viewport);

			//renderer
			renderer = new BasicRenderEngine();

			//light
			light = new PointLight3D();
			scene.addChild(light);
			
			obj = new Sphere(getMaterial(),100,32,32); 
			scene.addChild(obj);
			
			stage.addEventListener(Event.ENTER_FRAME, drawPapervision3d);
		}
		
		private function drawPapervision3d(e:Event):void {
			obj.material = getMaterial();
			obj.rotationY += 1;
			light.z = Math.cos(obj.rotationY / 180 * Math.PI) * 100;
			light.x = Math.sin(obj.rotationY / 180 * Math.PI) * 100;
			renderer.renderScene(scene, camera, viewport);
		}
		
		private function getMaterial():ShadedMaterial {
			offset += 1;
			var texBmp:BitmapData = new BitmapData(400,200);
			texBmp.perlinNoise(30,30,3,1,true,true,6,false,[new Point(-offset, -offset / 2)]);
			var bump:BitmapData = texBmp.clone()	;
			var filter:ColorMatrixFilter = new ColorMatrixFilter([0,1.5,-1.5,0,0, 0,1.5,-1.5,0,0, 0,1.5,-1.5,0,0, 0,0,0,1,0]);
			bump.applyFilter(bump, new Rectangle(0,0,texBmp.width, texBmp.height), new Point(0,0), filter);
			var phong:PhongShader=new PhongShader(light,0xFFFFFF, 0x221133 , 10 ,bump,bump);  
			var texture:BitmapMaterial=new BitmapMaterial(texBmp);  
			var material:ShadedMaterial = new ShadedMaterial(texture,phong); 
			return material;
		}
		
	}
}